/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.editor;

import java.lang.reflect.Array;
import java.util.EnumSet;
import javax.swing.JComboBox;
import org.nuiton.util.ReflectUtil;

public class EnumEditor<E extends Enum<E>>
extends JComboBox<E> {
    private static final long serialVersionUID = 2L;
    protected Class<E> type;

    public static <E extends Enum<E>> EnumEditor<E> newEditor(Class<E> type) {
        return new EnumEditor<E>(type);
    }

    public static <E extends Enum<E>> EnumEditor<E> newEditor(Class<E> type, int maxOrdinal) {
        return new EnumEditor<E>(type, maxOrdinal);
    }

    public static <E extends Enum<E>> EnumEditor<E> newEditor(E ... universe) {
        return new EnumEditor(universe);
    }

    public EnumEditor(Class<E> type) {
        super(EnumEditor.buildModel(type));
        this.type = type;
    }

    public EnumEditor(Class<E> type, int maxOrdinal) {
        super(EnumEditor.buildModel(type, (int)maxOrdinal));
        this.type = type;
    }

    public EnumEditor(E ... universe) {
        super(universe);
    }

    @Override
    public E getSelectedItem() {
        return (E)((Enum)super.getSelectedItem());
    }

    public Class<E> getType() {
        return this.type;
    }

    protected static <E extends Enum<E>> E[] buildModel(Class<E> type) {
        Class enumClass = ReflectUtil.getEnumClass(type);
        EnumSet all = EnumSet.allOf(enumClass);
        Enum[] result = (Enum[])Array.newInstance(type, all.size());
        System.arraycopy(all.toArray(), 0, result, 0, all.size());
        return result;
    }

    protected static <E extends Enum<E>> E[] buildModel(Class<E> type, int maxOrdinal) {
        Class enumClass = ReflectUtil.getEnumClass(type);
        EnumSet<Enum> all = EnumSet.allOf(enumClass);
        all.removeIf(e -> e.ordinal() > maxOrdinal);
        Enum[] result = (Enum[])Array.newInstance(type, all.size());
        System.arraycopy(all.toArray(), 0, result, 0, all.size());
        return result;
    }
}

