/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.nav.treetable;

import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jaxx.runtime.swing.nav.NavBridge;
import jaxx.runtime.swing.nav.treetable.NavTreeTableModel;
import jaxx.runtime.swing.nav.treetable.NavTreeTableNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class NavTreeTableBridge<N extends NavTreeTableNode<N>>
implements NavBridge<NavTreeTableModel, N> {
    private static final Log log = LogFactory.getLog(NavTreeTableBridge.class);
    protected NavTreeTableModel model;
    protected JXTreeTable ui;

    public NavTreeTableBridge() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("New " + this));
        }
    }

    @Override
    public NavTreeTableModel getModel() {
        return this.model;
    }

    @Override
    public N getRoot() {
        return (N)((NavTreeTableNode)this.model.getRoot());
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.model.isLeaf(node);
    }

    @Override
    public int getChildCount(Object parent) {
        return this.model.getChildCount(parent);
    }

    @Override
    public N getChild(Object parent, int index) {
        return (N)((NavTreeTableNode)this.model.getChild(parent, index));
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.model.getIndexOfChild(parent, child);
    }

    @Override
    public TreeNode[] getPathToRoot(TreeNode aNode) {
        return this.model.getPathToRoot((TreeTableNode)aNode);
    }

    @Override
    public void setModel(NavTreeTableModel model) {
        this.model = model;
    }

    @Override
    public void setRoot(N node) {
        this.model.setRoot((TreeTableNode)node);
    }

    @Override
    public void insertNodeInto(N newChild, N parent, int index) {
        this.model.nodeStructureChanged((NavTreeTableNode<?>)parent);
    }

    @Override
    public void removeNodeFromParent(N node) {
        this.model.nodeStructureChanged((NavTreeTableNode<?>)node);
    }

    @Override
    public void reload(N node) {
        this.model.getModelSupport().fireTreeStructureChanged(new TreePath(this.getPathToRoot((TreeNode)node)));
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.model.valueForPathChanged(path, newValue);
    }

    @Override
    public void nodeStructureChanged(TreeNode node) {
        this.model.nodeStructureChanged((NavTreeTableNode)node);
    }

    @Override
    public void nodeChanged(TreeNode node) {
        this.model.nodeChanged((NavTreeTableNode)node);
    }

    @Override
    public void nodesChanged(TreeNode node, int[] childIndices) {
        this.model.nodeChanged((NavTreeTableNode)node);
    }

    @Override
    public void nodesWereInserted(N parent, int[] indices) {
        this.nodeStructureChanged((TreeNode)parent);
    }

    @Override
    public void nodeWereInserted(N parentNode, int childIndice, N node) {
        this.nodeStructureChanged((TreeNode)node);
    }

    @Override
    public void nodesWereRemoved(TreeNode node, int[] childIndices, Object[] removedChildren) {
        TreePath path = new TreePath(this.getPathToRoot(node));
        this.model.getModelSupport().fireChildrenRemoved(path, childIndices, removedChildren);
    }

    @Override
    public void notifyChildNodesInserted(N node) {
        this.nodeStructureChanged((TreeNode)node);
    }

    @Override
    public void notifyNodeInserted(N node) {
        this.nodeStructureChanged((TreeNode)node);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.model.addTreeModelListener(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.model.removeTreeModelListener(l);
    }

    @Override
    public TreeModelListener[] getTreeModelListeners() {
        return this.model.getModelSupport().getTreeModelListeners();
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        TreeModelListener[] treeModelListeners = this.getTreeModelListeners();
        ArrayList<TreeModelListener> result = new ArrayList<TreeModelListener>();
        for (TreeModelListener listener : treeModelListeners) {
            if (!listener.getClass().isAssignableFrom(listenerType)) continue;
            result.add(listener);
        }
        return (EventListener[])result.toArray();
    }
}

