/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.field;

import java.io.File;
import jaxx.runtime.validator.BeanValidator;
import jaxx.runtime.validator.BeanValidatorField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class AbstractFieldValidatorTest<B>
extends Assert {
    private static final Log log = LogFactory.getLog(AbstractFieldValidatorTest.class);
    protected static BeanValidator<?> cacheValidator;
    protected static File basedir;
    protected final Class<B> type;
    protected BeanValidator<B> validator;
    protected B bean;

    public AbstractFieldValidatorTest(Class<B> type) {
        this.type = type;
    }

    public abstract void testValidator() throws Exception;

    @Before
    public void setUp() throws Exception {
        log.debug((Object)("start test " + ((Object)((Object)this)).getClass().getSimpleName()));
        this.bean = this.type.newInstance();
        if (cacheValidator == null) {
            this.validator = this.validator = new BeanValidator(this.type, null);
            cacheValidator = this.validator;
        } else {
            this.validator = cacheValidator;
        }
        this.validator.setBean(this.bean);
    }

    @After
    public void tearDown() {
        this.validator.setBean(null);
    }

    @AfterClass
    public static void afterclass() throws Exception {
        cacheValidator = null;
    }

    @BeforeClass
    public static void initValidator() throws Exception {
        String b = System.getenv("basedir");
        if (b == null) {
            b = new File("").getAbsolutePath();
        }
        basedir = new File(b);
    }

    protected void assertFieldInError(String fieldName, String error, boolean required) {
        BeanValidatorField field = this.validator.getField(fieldName);
        if (field != null && field.getErrors() != null) {
            for (String o : field.getErrors()) {
                if (!o.equals(error)) continue;
                AbstractFieldValidatorTest.assertTrue((String)("error " + error + " should not exist but was found."), (boolean)required);
                return;
            }
        }
        AbstractFieldValidatorTest.assertFalse((String)("error " + error + " should exist but was not found."), (boolean)required);
    }
}

