/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: NavigationTreeModelBuilder.java 1986 2010-06-23 08:58:14Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.1/jaxx-runtime/src/main/java/jaxx/runtime/swing/navigation/tree/NavigationTreeModelBuilder.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.navigation.tree;

import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.navigation.AbstractNavigationModelBuilder;
import jaxx.runtime.swing.navigation.NavigationModelBuilder;

/**
 * This object is design to build a {@link NavigationTreeModel}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @see NavigationModelBuilder
 * @since 17.2
 * @deprecated since 2.1, prefer use the simplify api {@code jaxx.runtime.swing.tree}.
 */
@Deprecated
public class NavigationTreeModelBuilder extends AbstractNavigationModelBuilder<NavigationTreeNode> {

    public NavigationTreeModelBuilder(
            String pathSeparator,
            JAXXContext context,
            Class<? extends JAXXObject> defaultUIClass,
            Class<? extends JAXXAction> defaultUIHandlerClass) {
        this(defaultUIClass,
             defaultUIHandlerClass,
             new NavigationTreeModel(pathSeparator, context)
        );
    }

    public NavigationTreeModelBuilder(
            Class<? extends JAXXObject> defaultUIClass,
            Class<? extends JAXXAction> defaultUIHandlerClass,
            NavigationTreeModel model) {
        super(defaultUIClass, defaultUIHandlerClass, model);
    }

    @Override
    public NavigationTreeNode createNavigationNode(
            String pathSeparator,
            String contextName,
            JAXXContextEntryDef<?> jaxxContextEntryDef,
            String jaxxContextEntryPath) {
        return new NavigationTreeNode(
                pathSeparator,
                contextName,
                jaxxContextEntryDef,
                jaxxContextEntryPath
        );
    }

    @Override
    public NavigationTreeModel getModel() {
        return (NavigationTreeModel) super.getModel();
    }
}
