/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: NavigationTreeModel.java 1986 2010-06-23 08:58:14Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.1/jaxx-runtime/src/main/java/jaxx/runtime/swing/navigation/tree/NavigationTreeModel.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.navigation.tree;

import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.AbstractNavigationModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

/**
 * Model of the tree used for a navigation tree.
 * <p/>
 * Il est composé de {@link NavigationTreeNode}
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.7.2
 * @deprecated since 2.1, prefer use the simplify api {@code jaxx.runtime.swing.tree}.
 */
@Deprecated
public class NavigationTreeModel extends AbstractNavigationModel<NavigationTreeNode> implements TreeModel {

    /** Logger */
    private static final Log log =
            LogFactory.getLog(NavigationTreeModel.class);

    public NavigationTreeModel(String pathSeparator, JAXXContext context) {
        super(new DefaultTreeModel(null), pathSeparator, context);
    }

    @Override
    public void setRoot(NavigationTreeNode root) {
        getDelegate().setRoot(root);
    }

    public DefaultTreeModel getDelegate() {
        return (DefaultTreeModel) super.getDelegate();
    }

    @Override
    public NavigationTreeNode[] getPathToRoot(NavigationTreeNode aNode) {
        TreeNode[] treeNodes = getDelegate().getPathToRoot(aNode);
        NavigationTreeNode[] result = new NavigationTreeNode[treeNodes.length];
        System.arraycopy(treeNodes, 0, result, 0, treeNodes.length);
        return result;
    }

    @Override
    public void removeNodeFromParent(NavigationTreeNode node) {
        getDelegate().removeNodeFromParent(node);
    }

    @Override
    public void nodeStructureChanged(NavigationTreeNode node) {
        if (isAdjustingValue()) {
            return;
        }
        NavigationTreeNode n = node;
        //TC-20091004 never launch a deep reload
        reload(n, true);
        getDelegate().nodeStructureChanged(node);
        if (log.isDebugEnabled()) {
            log.debug(node);
        }
    }

    @Override
    public void nodeChanged(NavigationTreeNode node, boolean deep) {
        if (isAdjustingValue()) {
            return;
        }
        NavigationTreeNode n = node;
        //TC-20091004 never launch a deep clean, since we do a deep nodeChanged.
        reload(n, deep);
        getDelegate().nodeChanged(node);
    }


}
