/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: NavTreeTableHelper.java 2014 2010-06-30 17:24:16Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.1/jaxx-runtime/src/main/java/jaxx/runtime/swing/nav/treetable/NavTreeTableHelper.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.nav.treetable;

import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.tree.AbstractNavTreeCellRenderer;
import org.jdesktop.swingx.JXTreeTable;

import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

/**
 * The implementation of {@link NavHelper} based on a {@link JXTreeTable} component.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.1
 */
public class NavTreeTableHelper<N extends NavTreeTableNode<N>> extends NavHelper<NavTreeTableModel, JXTreeTable, NavTreeTableBridge<N>, N> {

    public NavTreeTableHelper() {
        super(new NavTreeTableBridge<N>());
    }

    @Override
    public void scrollPathToVisible(TreePath path) {
        getUI().scrollPathToVisible(path);
    }

    @Override
    public void setSelectionPath(TreePath path) {
        getUI().getTreeSelectionModel().setSelectionPath(path);
    }

    @Override
    public TreeSelectionModel getSelectionModel() {
        return getUI().getTreeSelectionModel();
    }

    @Override
    public boolean isExpanded(TreePath pathToExpand) {
        return getUI().isExpanded(pathToExpand);
    }

    @Override
    public void expandPath(TreePath pathToExpand) {
        getUI().expandPath(pathToExpand);
    }

    @Override
    public AbstractNavTreeCellRenderer<NavTreeTableModel, N> getTreeCellRenderer() {
        //FIXME Implements it if possible
        return null;
    }

    @SuppressWarnings({"unchecked"})
    @Override
    public N getSelectedNode() {
        TreePath path = getSelectionModel().getSelectionPath();
        N node = null;
        if (path != null) {
            node = (N) path.getLastPathComponent();
        }
        return node;
    }

    /**
     * Registers the given {@code treeTable} for this helper.
     * <p/>
     * <b>Note:</b> as a side-effect, it will register (if required) the
     * {@link #expandListener} listener and the {@link #selectionListener}.
     *
     * @param treeTable             the tree table to register
     * @param addExpandTreeListener a flag to add expand listener
     * @param listener              the optional selection listener to add
     */
    @SuppressWarnings({"unchecked"})
    @Override
    public void setUI(JXTreeTable treeTable,
                      boolean addExpandTreeListener,
                      TreeSelectionListener listener) {
        setUI(treeTable);
        if (addExpandTreeListener) {
            treeTable.addTreeWillExpandListener(expandListener);
        }
        if (listener != null) {
            treeTable.addTreeSelectionListener(listener);
        }
        treeTable.addTreeSelectionListener(selectionListener);
    }

    @Override
    protected NavTreeTableModel createModel(N node, Object... extraArgs) {

        // must have a single extra params with delegate model
        if (extraArgs.length != 1) {
            throw new IllegalArgumentException("Should have exactly one extra parameter (delegate model)");
        }
        if (!(extraArgs[0] instanceof NavTreeTableModel.MyDefaultTreeTableModel)) {
            throw new IllegalArgumentException("extra parameter is not instance of " + NavTreeTableModel.MyDefaultTreeTableModel.class.getName());
        }
        NavTreeTableModel.MyDefaultTreeTableModel delegate = (NavTreeTableModel.MyDefaultTreeTableModel) extraArgs[0];
        NavTreeTableBridge<N> bridge = getBridge();
        NavTreeTableModel model = bridge.getModel();
        if (model == null) {
            model = new NavTreeTableModel(delegate);
            bridge.setModel(model);
//            model = new NavTreeTableBridge(tableModel);
            bridge.addTreeModelListener(treeModelListener);
//            ((NavTreeTableModel) model).addTreeModelListener(treeModelListener);
        }
        bridge.setRoot(node);

        // notify structure has changed
        bridge.nodeStructureChanged(getRootNode());
        return model;
    }
}