/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator;

import java.beans.EventSetDescriptor;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.event.EventListenerList;
import jaxx.runtime.validator.BeanValidatorEvent;
import jaxx.runtime.validator.BeanValidatorField;
import jaxx.runtime.validator.BeanValidatorListener;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.BeanValidatorUtil;
import jaxx.runtime.validator.XWorkBeanValidator;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.converter.ConverterUtil;

public class BeanValidator<B> {
    public static final String BEAN_PROERTY = "bean";
    public static final String CONTEXT_NAME_PROPERTY = "contextName";
    public static final String VALID_PROERTY = "valid";
    public static final String CHANGED_PROERTY = "changed";
    protected static final Log log = LogFactory.getLog(BeanValidator.class);
    protected static final BeanValidatorScope[] FILTER_SCOPES_EMPTY = new BeanValidatorScope[0];
    protected final Class<B> beanClass;
    protected String contextName;
    protected BeanValidator<?> parentValidator;
    protected boolean changed;
    protected boolean valid = true;
    protected B bean;
    protected EventSetDescriptor beanEventDescriptor;
    protected Set<BeanValidatorField<B>> fields;
    protected Map<String, String> conversionErrors;
    protected EnumMap<BeanValidatorScope, XWorkBeanValidator<B>> validators;
    protected BeanValidatorScope[] filterScopes;
    protected PropertyChangeListener l;
    protected PropertyChangeSupport pcs;
    protected EventListenerList listenerList = new EventListenerList();

    public BeanValidator(Class<B> beanClass, String contextName) {
        this(beanClass, contextName, BeanValidatorScope.values());
    }

    public BeanValidator(Class<B> beanClass, String contextName, BeanValidatorScope ... filterScopes) {
        this.beanClass = beanClass;
        if (filterScopes != null && filterScopes.length > 0) {
            this.filterScopes = filterScopes;
        }
        this.pcs = new PropertyChangeSupport(this);
        this.conversionErrors = new TreeMap<String, String>();
        this.validators = new EnumMap(BeanValidatorScope.class);
        this.setContextName(contextName);
        this.l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BeanValidator.this.doValidate();
            }
        };
    }

    public Class<B> getBeanClass() {
        return this.beanClass;
    }

    public BeanValidator<?> getParentValidator() {
        return this.parentValidator;
    }

    public String getContextName() {
        return this.contextName;
    }

    public Set<BeanValidatorField<B>> getFields() {
        return this.fields;
    }

    public Set<BeanValidatorScope> getScopes() {
        return new HashSet<BeanValidatorScope>(this.validators.keySet());
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isValid() {
        return this.valid;
    }

    public B getBean() {
        return this.bean;
    }

    public BeanValidatorField<B> getField(String fieldName) {
        for (BeanValidatorField<B> field : this.fields) {
            if (!fieldName.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public boolean hasErrors() {
        for (BeanValidatorField<B> field : this.fields) {
            if (!field.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public boolean hasWarnings() {
        for (BeanValidatorField<B> field : this.fields) {
            if (!field.hasWarnings()) continue;
            return true;
        }
        return false;
    }

    public boolean hasInfos() {
        for (BeanValidatorField<B> field : this.fields) {
            if (!field.hasInfos()) continue;
            return true;
        }
        return false;
    }

    public boolean containsField(String fieldName) {
        BeanValidatorField<B> field = this.getField(fieldName);
        return field != null;
    }

    public boolean isValid(String fieldName) {
        BeanValidatorField<B> field = this.getField(fieldName);
        if (field == null) {
            throw new IllegalArgumentException("could not find a validator field " + fieldName);
        }
        return field.isValid();
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
        this.pcs.firePropertyChange(CHANGED_PROERTY, null, (Object)changed);
    }

    public void setValid(boolean valid) {
        this.valid = valid;
        this.pcs.firePropertyChange(VALID_PROERTY, null, (Object)valid);
    }

    public void setBean(B bean) {
        EventSetDescriptor descriptor;
        B oldBean = this.bean;
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + " : " + bean));
        }
        this.conversionErrors.clear();
        if (oldBean != null) {
            try {
                descriptor = this.getBeanEventDescriptor(oldBean);
                descriptor.getRemoveListenerMethod().invoke(oldBean, this.l);
            }
            catch (Exception eee) {
                log.info((Object)("Can't register as listener for bean " + this.beanClass + " for reason " + eee.getMessage()), (Throwable)eee);
            }
        }
        this.bean = bean;
        if (bean == null) {
            for (BeanValidatorField<B> f : this.fields) {
                f.updateMessages(this, null, null);
            }
        } else {
            try {
                descriptor = this.getBeanEventDescriptor(bean);
                descriptor.getAddListenerMethod().invoke(bean, this.l);
            }
            catch (Exception eee) {
                log.info((Object)("Can't register as listener for bean " + this.beanClass + " for reason " + eee.getMessage()), (Throwable)eee);
            }
            this.validate();
        }
        this.setChanged(false);
        this.setValid(!this.hasErrors());
        this.pcs.firePropertyChange(BEAN_PROERTY, oldBean, bean);
    }

    public void setContextName(String contextName) {
        String oldContextName = this.contextName;
        this.contextName = contextName;
        if (this.bean != null) {
            this.setBean(null);
        }
        this.initFields();
        this.pcs.firePropertyChange(CONTEXT_NAME_PROPERTY, oldContextName, contextName);
    }

    public void setFilterScopes(BeanValidatorScope ... filterScopes) {
        this.filterScopes = filterScopes;
        if (this.bean != null) {
            this.setBean(null);
        }
        this.initFields();
    }

    public void setParentValidator(BeanValidator<?> parentValidator) {
        this.parentValidator = parentValidator;
    }

    public <T> T convert(String fieldName, String value, Class<T> valueClass) {
        Object result;
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName can not be null");
        }
        if (valueClass == null) {
            throw new IllegalArgumentException("valueClass can not be null");
        }
        if (!this.canValidate() || value == null) {
            return null;
        }
        this.conversionErrors.remove(fieldName);
        try {
            Converter converter = ConverterUtil.getConverter(valueClass);
            if (converter == null) {
                throw new RuntimeException("could not find converter for the type " + valueClass);
            }
            result = converter.convert(valueClass, (Object)value);
        }
        catch (ConversionException e) {
            String s = Introspector.decapitalize(valueClass.getSimpleName());
            this.conversionErrors.put(fieldName, "error.convertor." + s);
            result = null;
            this.validate();
        }
        return (T)result;
    }

    public void doValidate() {
        this.validate();
        this.setValid(!this.hasErrors());
        this.setChanged(true);
    }

    public void validate() {
        if (!this.canValidate()) {
            return;
        }
        for (BeanValidatorScope scope : this.validators.keySet()) {
            XWorkBeanValidator<B> validator = this.validators.get((Object)scope);
            Map<String, List<String>> newMessages = validator.validate(this.bean);
            if (scope == BeanValidatorScope.ERROR) {
                for (Map.Entry entry : this.conversionErrors.entrySet()) {
                    List<String> errors = newMessages.get(entry.getKey());
                    String conversionError = (String)entry.getValue();
                    if (errors != null) {
                        errors.clear();
                        errors.add(conversionError);
                        continue;
                    }
                    errors = Collections.singletonList(conversionError);
                    if (newMessages == XWorkBeanValidator.EMPTY_RESULT) {
                        newMessages = new HashMap<String, List<String>>();
                    }
                    newMessages.put((String)entry.getKey(), errors);
                }
            }
            for (BeanValidatorField beanValidatorField : this.fields) {
                List<String> messagesForField = newMessages.get(beanValidatorField.getName());
                if (!beanValidatorField.getScopes().contains((Object)scope)) continue;
                beanValidatorField.updateMessages(this, scope, messagesForField);
            }
        }
        if (this.parentValidator != null) {
            boolean wasModified = this.parentValidator.isChanged();
            this.parentValidator.doValidate();
            if (!wasModified) {
                this.parentValidator.setChanged(false);
            }
        }
    }

    public String toString() {
        return super.toString() + "<beanClass:" + this.beanClass + ", contextName:" + this.contextName + ">";
    }

    public void addBeanValidatorListener(BeanValidatorListener listener) {
        this.listenerList.add(BeanValidatorListener.class, listener);
    }

    public void removeBeanValidatorListener(BeanValidatorListener listener) {
        this.listenerList.remove(BeanValidatorListener.class, listener);
    }

    public BeanValidatorListener[] getBeanValidatorListeners() {
        return (BeanValidatorListener[])this.listenerList.getListeners(BeanValidatorListener.class);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected boolean canValidate() {
        return this.bean != null && !this.fields.isEmpty();
    }

    protected void fireFieldChanged(BeanValidatorField<B> field, BeanValidatorScope scope, String[] toAdd, String[] toDelete) {
        BeanValidatorEvent evt = new BeanValidatorEvent(this, field, scope, toAdd, toDelete);
        for (BeanValidatorListener listener : (BeanValidatorListener[])this.listenerList.getListeners(BeanValidatorListener.class)) {
            listener.onFieldChanged(evt);
        }
    }

    protected synchronized void initFields() {
        HashSet<String> detectedFieldNames = new HashSet<String>();
        EnumMap<BeanValidatorScope, Set<String>> tmp = new EnumMap<BeanValidatorScope, Set<String>>(BeanValidatorScope.class);
        HashSet<BeanValidatorField<B>> detectedFields = new HashSet<BeanValidatorField<B>>();
        this.validators.clear();
        BeanValidatorScope[] scopeUniverse = this.filterScopes == null ? BeanValidatorScope.values() : this.filterScopes;
        for (BeanValidatorScope scope : scopeUniverse) {
            String scopeContext = (this.contextName == null ? "" : this.contextName + "-") + scope.name().toLowerCase();
            XWorkBeanValidator<B> newValidator = new XWorkBeanValidator<B>(this.beanClass, scopeContext, false);
            Set<String> fieldNames = newValidator.getFieldNames();
            if (log.isDebugEnabled()) {
                log.debug((Object)("detected validators for scope " + scopeContext + " : " + fieldNames));
            }
            if (fieldNames.isEmpty()) continue;
            this.validators.put(scope, newValidator);
            detectedFieldNames.addAll(fieldNames);
            tmp.put(scope, fieldNames);
        }
        ArrayList<BeanValidatorScope> scopes = new ArrayList<BeanValidatorScope>();
        for (String fieldName : detectedFieldNames) {
            scopes.clear();
            for (BeanValidatorScope scope : scopeUniverse) {
                if (!tmp.containsKey((Object)scope) || !((Set)tmp.get((Object)scope)).contains(fieldName)) continue;
                scopes.add(scope);
            }
            BeanValidatorField<B> f = new BeanValidatorField<B>(this.beanClass, fieldName, scopes);
            detectedFields.add(f);
        }
        tmp.clear();
        detectedFieldNames.clear();
        this.fields = Collections.unmodifiableSet(detectedFields);
    }

    protected EventSetDescriptor getBeanEventDescriptor(B bean) {
        if (this.beanEventDescriptor == null) {
            this.beanEventDescriptor = BeanValidatorUtil.getPropertyChangeListenerDescriptor(bean.getClass());
        }
        return this.beanEventDescriptor;
    }
}

