/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.NavigationModel;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.tree.NavigationTreeModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public abstract class AbstractNavigationModel<E extends NavigationNode<E>>
implements NavigationModel<E> {
    private static final Log log = LogFactory.getLog(NavigationTreeModel.class);
    protected final TreeModel delegate;
    protected final String pathSeparator;
    private JAXXContext context;
    protected boolean adjustingValue;

    public AbstractNavigationModel(TreeModel delegate, String pathSeparator, JAXXContext context) {
        this.pathSeparator = pathSeparator;
        this.context = context;
        this.delegate = delegate;
    }

    @Override
    public boolean isAdjustingValue() {
        return this.adjustingValue;
    }

    @Override
    public void setAdjustingValue(boolean adjustingValue) {
        this.adjustingValue = adjustingValue;
    }

    @Override
    public JAXXContext getContext() {
        return this.context;
    }

    public TreeModel getDelegate() {
        return this.delegate;
    }

    @Override
    public final String getPathSeparator() {
        return this.pathSeparator;
    }

    @Override
    public final E getRoot() {
        return (E)((NavigationNode)this.getDelegate().getRoot());
    }

    @Override
    public final Object getBean(String navigationPath) {
        E node = this.findNode(navigationPath, (Pattern)null);
        Object result = this.getBean(node);
        return result;
    }

    @Override
    public final Object getBean(E node) {
        if (node == null) {
            return null;
        }
        return node.getBean(this.getContext());
    }

    @Override
    public final E findNode(String path) {
        return this.findNode(this.getRoot(), path, (Pattern)null);
    }

    @Override
    public final E findNode(String path, String regex) {
        return this.findNode(this.getRoot(), path, regex);
    }

    @Override
    public final E findNode(String path, Pattern regex) {
        return this.findNode(this.getRoot(), path, regex);
    }

    @Override
    public final E findNode(E root, String path) {
        return this.findNode(root, path, (Pattern)null);
    }

    @Override
    public final E findNode(E root, String path, String regex) {
        return this.findNode(root, path, regex == null ? null : Pattern.compile(regex));
    }

    @Override
    public final E findNode(E root, String path, Pattern regex) {
        String rootPath;
        if (regex != null) {
            Matcher matcher = regex.matcher(path);
            if (!matcher.matches() || matcher.groupCount() < 1) {
                log.warn((Object)("no matching regex " + regex + " to " + path));
                return null;
            }
            path = matcher.group(1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("matching regex " + regex + " : " + path));
            }
        }
        StringTokenizer stk = new StringTokenizer(path, this.pathSeparator);
        E result = root;
        if (root.isRoot() && stk.hasMoreTokens() && !(rootPath = stk.nextToken()).equals(root.getNodePath())) {
            return null;
        }
        while (stk.hasMoreTokens()) {
            result = result.getChild(stk.nextToken());
        }
        return result;
    }

    @Override
    public final void nodeChanged(E node) {
        if (this.adjustingValue) {
            return;
        }
        this.nodeChanged(node, false);
        if (log.isDebugEnabled()) {
            log.debug(node);
        }
    }

    protected final void reload(E node) {
        if (this.adjustingValue) {
            return;
        }
        this.reload(node, false);
    }

    protected final void reload(E node, boolean deep) {
        if (node == null) {
            return;
        }
        if (this.adjustingValue) {
            return;
        }
        node.reload(this.getContext());
        if (deep) {
            Enumeration childs = node.children();
            while (childs.hasMoreElements()) {
                NavigationNode o = (NavigationNode)childs.nextElement();
                this.reload(o, true);
            }
        }
    }

    @Override
    public final Object getChild(Object parent, int index) {
        return this.getDelegate().getChild(parent, index);
    }

    @Override
    public final int getChildCount(Object parent) {
        return this.getDelegate().getChildCount(parent);
    }

    @Override
    public final boolean isLeaf(Object node) {
        return this.getDelegate().isLeaf(node);
    }

    @Override
    public final void valueForPathChanged(TreePath path, Object newValue) {
        if (this.adjustingValue) {
            return;
        }
        this.getDelegate().valueForPathChanged(path, newValue);
    }

    @Override
    public final int getIndexOfChild(Object parent, Object child) {
        return this.getDelegate().getIndexOfChild(parent, child);
    }

    @Override
    public final void addTreeModelListener(TreeModelListener l) {
        this.getDelegate().addTreeModelListener(l);
    }

    @Override
    public final void removeTreeModelListener(TreeModelListener l) {
        this.getDelegate().removeTreeModelListener(l);
    }
}

