/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.navigation.NavigationModel;
import jaxx.runtime.swing.navigation.NavigationTreeHandler;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;

public class NavigationTreeContextHelper {
    private static final Log log = LogFactory.getLog(NavigationTreeContextHelper.class);
    protected final String prefix;
    protected JAXXContextEntryDef<List<String>> selectedPathsContextEntry;
    protected JAXXContextEntryDef<List<Object>> selectedBeansContextEntry;
    protected JAXXContextEntryDef<List<NavigationTreeNode>> selectedNodesContextEntry;
    protected JAXXContextEntryDef<NavigationModel> modelContextEntry;
    protected JAXXContextEntryDef<NavigationTreeHandler> handlerContextEntry;
    protected JAXXContextEntryDef<JTree> treeContextEntry;
    protected JAXXContextEntryDef<JXTreeTable> treeTableContextEntry;

    public NavigationTreeContextHelper(String prefix) {
        this.prefix = prefix;
        this.treeContextEntry = JAXXUtil.newContextEntryDef(prefix + "-tree", JTree.class);
        this.treeTableContextEntry = JAXXUtil.newContextEntryDef(prefix + "-tree-table", JXTreeTable.class);
        this.modelContextEntry = JAXXUtil.newContextEntryDef(prefix + "-model", NavigationModel.class);
        this.handlerContextEntry = JAXXUtil.newContextEntryDef(prefix + "-handler", NavigationTreeHandler.class);
        this.selectedBeansContextEntry = JAXXUtil.newListContextEntryDef(prefix + "-selected-beans");
        this.selectedNodesContextEntry = JAXXUtil.newListContextEntryDef(prefix + "-selected-nodes");
        this.selectedPathsContextEntry = JAXXUtil.newListContextEntryDef(prefix + "-selected-paths");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public JTree getTree(JAXXContext context) {
        JTree r = this.getTreeContextEntry().getContextValue(context);
        return r;
    }

    public JXTreeTable getTreeTable(JAXXContext context) {
        JXTreeTable r = this.getTreeTableContextEntry().getContextValue(context);
        return r;
    }

    public NavigationModel getModel(JAXXContext context) {
        NavigationModel r = this.getModelContextEntry().getContextValue(context);
        return r;
    }

    @Deprecated
    public NavigationTreeModel getTreeModel(JAXXContext context) {
        NavigationModel r = this.getModel(context);
        if (r instanceof NavigationTreeModel) {
            return (NavigationTreeModel)r;
        }
        return null;
    }

    public NavigationTreeHandler getTreeHandler(JAXXContext context) {
        NavigationTreeHandler r = this.getTreeHandlerContextEntry().getContextValue(context);
        return r;
    }

    public String getSelectedPath(JAXXContext context) {
        String result = (String)this.getSelectedValue(this.getSelectedPathContextEntry(), context);
        return result;
    }

    public List<String> getSelectedPaths(JAXXContext context) {
        return this.getSelectedPathContextEntry().getContextValue(context);
    }

    public NavigationTreeNode getSelectedNode(JAXXContext context) {
        NavigationTreeNode result = (NavigationTreeNode)this.getSelectedValue(this.getSelectedNodeContextEntry(), context);
        return result;
    }

    public List<NavigationTreeNode> getSelectedNodes(JAXXContext context) {
        return this.getSelectedNodeContextEntry().getContextValue(context);
    }

    public Object getSelectedBean(JAXXContext context) {
        Object result = this.getSelectedValue(this.getSelectedBeanContextEntry(), context);
        return result;
    }

    public List<Object> getSelectedBeans(JAXXContext context) {
        return this.getSelectedBeanContextEntry().getContextValue(context);
    }

    @Deprecated
    public void setTreeModel(JAXXContext context, NavigationModel model) {
        this.setModel(context, model);
    }

    public void setModel(JAXXContext context, NavigationModel model) {
        this.getModelContextEntry().setContextValue(context, model);
    }

    public void setTree(JAXXContext context, JTree tree) {
        this.getTreeContextEntry().setContextValue(context, tree);
    }

    public void setTreeTable(JAXXContext context, JXTreeTable treeTable) {
        this.getTreeTableContextEntry().setContextValue(context, treeTable);
    }

    public void setTreeHandler(JAXXContext context, NavigationTreeHandler handler) {
        this.getTreeHandlerContextEntry().setContextValue(context, handler);
    }

    public void setSelectedPath(JAXXContext context, String path) {
        this.setSelectedValue(this.getSelectedPathContextEntry(), context, path);
    }

    public void setSelectedPaths(JAXXContext context, List<String> paths) {
        this.setSelectedValues(this.getSelectedPathContextEntry(), context, paths);
    }

    public void setSelectedNode(JAXXContext context, NavigationTreeNode node) {
        this.setSelectedValue(this.getSelectedNodeContextEntry(), context, node);
    }

    public void setSelectedNodes(JAXXContext context, List<NavigationTreeNode> nodes) {
        this.setSelectedValues(this.getSelectedNodeContextEntry(), context, nodes);
    }

    public void setSelectedBean(JAXXContext context, Object bean) {
        this.setSelectedValue(this.getSelectedBeanContextEntry(), context, bean);
    }

    public void setSelectedBeans(JAXXContext context, List<Object> beans) {
        this.setSelectedValues(this.getSelectedBeanContextEntry(), context, beans);
    }

    protected JAXXContextEntryDef<NavigationModel> getModelContextEntry() {
        return this.modelContextEntry;
    }

    protected JAXXContextEntryDef<NavigationTreeHandler> getTreeHandlerContextEntry() {
        return this.handlerContextEntry;
    }

    protected JAXXContextEntryDef<List<Object>> getSelectedBeanContextEntry() {
        return this.selectedBeansContextEntry;
    }

    protected JAXXContextEntryDef<List<NavigationTreeNode>> getSelectedNodeContextEntry() {
        return this.selectedNodesContextEntry;
    }

    protected JAXXContextEntryDef<List<String>> getSelectedPathContextEntry() {
        return this.selectedPathsContextEntry;
    }

    protected JAXXContextEntryDef<JTree> getTreeContextEntry() {
        return this.treeContextEntry;
    }

    protected JAXXContextEntryDef<JXTreeTable> getTreeTableContextEntry() {
        return this.treeTableContextEntry;
    }

    protected <T> T getSelectedValue(JAXXContextEntryDef<List<T>> entry, JAXXContext context) {
        List<T> values = entry.getContextValue(context);
        T result = null;
        if (values != null && !values.isEmpty()) {
            if (values.size() > 1 && log.isWarnEnabled()) {
                log.warn((Object)("There is " + values.size() + " values selected, will return first one"));
            }
            result = values.get(0);
        }
        return result;
    }

    protected <T> void setSelectedValue(JAXXContextEntryDef<List<T>> entry, JAXXContext context, T value) {
        if (value == null) {
            entry.removeContextValue(context);
        } else {
            ArrayList<T> selecteds = new ArrayList<T>();
            selecteds.add(value);
            entry.setContextValue(context, selecteds);
        }
    }

    protected <T> void setSelectedValues(JAXXContextEntryDef<List<T>> entry, JAXXContext context, List<T> values) {
        if (values == null || values.isEmpty()) {
            entry.removeContextValue(context);
        } else {
            entry.setContextValue(context, values);
        }
    }
}

