/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.navigation.NavigationMultiContentUI;
import jaxx.runtime.swing.navigation.NavigationTreeContextHelper;
import jaxx.runtime.swing.navigation.NavigationTreeHandler;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NavigationMultiTreeHandler
extends NavigationTreeHandler {
    private static final Log log = LogFactory.getLog(NavigationMultiTreeHandler.class);

    public NavigationMultiTreeHandler(String contextPrefix, JAXXObject context, NavigationTreeHandler.Strategy strategy) {
        super(contextPrefix, context, strategy);
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        TreePath[] paths = event.getPaths();
        ArrayList<NavigationTreeNode> nodes = new ArrayList<NavigationTreeNode>();
        if (paths == null) {
            this.selectNodeUI(new ArrayList<NavigationTreeNode>());
            return;
        }
        for (TreePath path : paths) {
            NavigationTreeNode node = (NavigationTreeNode)path.getLastPathComponent();
            nodes.add(node);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Adding path : " + path));
            log.debug((Object)("As node : " + node.getFullPath()));
        }
        this.selectNodeUI(nodes);
    }

    protected abstract void openUI(Component var1, List<NavigationTreeNode> var2) throws Exception;

    protected abstract Component createUI(List<NavigationTreeNode> var1) throws Exception;

    protected abstract Component getUI(List<NavigationTreeNode> var1);

    protected void selectNodeUI(List<NavigationTreeNode> nodes) {
        log.info((Object)("select nodes " + nodes));
        try {
            ArrayList<String> paths = new ArrayList<String>();
            ArrayList<Object> beans = new ArrayList<Object>();
            for (NavigationTreeNode node : nodes) {
                String path = node.getFullPath();
                paths.add(path);
                if (log.isTraceEnabled()) {
                    log.trace((Object)path);
                }
                beans.add(this.getNavigationTreeModel().getBean(path));
            }
            Component newUI = this.getUI(nodes);
            JAXXContext ctxt = this.getContext();
            NavigationTreeContextHelper helper = this.getContextHelper();
            helper.setSelectedBean(ctxt, null);
            if (beans != null) {
                helper.setSelectedBeans(ctxt, beans);
            }
            if (newUI == null) {
                newUI = this.createUI(nodes);
            }
            helper.setSelectedPaths(ctxt, this.getPaths(nodes));
            helper.setSelectedNodes(ctxt, nodes);
            if (newUI instanceof NavigationMultiContentUI) {
                ((NavigationMultiContentUI)((Object)newUI)).openUI(nodes);
            }
            this.openUI(newUI, nodes);
        }
        catch (Exception e) {
            this.treateError(e);
        }
    }

    public List<String> getPaths(List<NavigationTreeNode> nodes) {
        ArrayList<String> result = new ArrayList<String>();
        for (NavigationTreeNode node : nodes) {
            result.add(node.getFullPath());
        }
        return result;
    }
}

