/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.Util;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationTreeModelBuilder;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.junit.Assert;
import org.junit.Test;

public class NavigationTreeModelTest {
    private static final String ROOT_CONTEXT = "$root";
    private static final String FAKE = "-fake";
    private static final String separator = "/";

    @Test
    public void testFindNode() throws Exception {
        NavigationTreeModelBuilder builder = new NavigationTreeModelBuilder(separator, (JAXXContext)new DefaultJAXXContext(), null, null);
        NavigationTreeNode rootNode = builder.build(null, (String)null, (String)null, ROOT_CONTEXT, null, null);
        for (int i = 0; i < 4; ++i) {
            NavigationTreeNode sonNode = builder.build(rootNode, (String)null, (String)null, this.getNodeContext(i), null, null);
            for (int j = 0; j < 4; ++j) {
                NavigationTreeNode sonSonNode = builder.build(sonNode, (String)null, (String)null, this.getNodeContext(i, j), null, null);
                int k = 0;
                while (k < 4) {
                    builder.build(sonSonNode, (String)null, (String)null, this.getNodeContext(i, j, k++), null, null);
                }
            }
        }
        NavigationTreeModel model = builder.getModel();
        String contextPath = ROOT_CONTEXT;
        NavigationTreeNode node = model.findNode(contextPath);
        this.assertNodeEquals(contextPath, ROOT_CONTEXT, 0, node, true);
        node = model.findNode("$root-fake");
        Assert.assertNull((Object)node);
        int i = 0;
        while (i < 4) {
            String currentNode = this.getNodeContext(i);
            contextPath = "$root/" + currentNode;
            node = model.findNode(contextPath);
            this.assertNodeEquals(contextPath, currentNode, 1, node, false);
            int j = 0;
            while (j < 4) {
                currentNode = this.getNodeContext(i, j);
                contextPath = "$root/" + this.getNodeContext(i) + separator + currentNode;
                node = model.findNode(contextPath);
                this.assertNodeEquals(contextPath, currentNode, 2, node, false);
                int k = 0;
                while (k < 4) {
                    currentNode = this.getNodeContext(i, j, k++);
                    contextPath = "$root/" + this.getNodeContext(i) + separator + this.getNodeContext(i, j) + separator + currentNode;
                    node = model.findNode(contextPath);
                    this.assertNodeEquals(contextPath, currentNode, 3, node, false);
                }
                node = model.findNode("$root/" + this.getNodeContext(i) + separator + this.getNodeContext(i, j++) + separator + currentNode + FAKE);
                Assert.assertNull((Object)node);
            }
            node = model.findNode("$root/" + this.getNodeContext(i++) + separator + currentNode + FAKE);
            Assert.assertNull((Object)node);
        }
    }

    @Test
    public void testGetJAXXContextValue() throws Exception {
        DefaultJAXXContext context = new DefaultJAXXContext();
        context.setContextValue((Object)"the name", "name");
        context.setContextValue((Object)"the name2", "name2");
        context.setContextValue((Object)new Model("modelName", 10, Arrays.asList(new Model("one", 1, Collections.<Model>emptyList()), new Model("two", 2, Collections.<Model>emptyList()), new Model("three", 3, Collections.<Model>emptyList()))));
        NavigationTreeModelBuilder builder = new NavigationTreeModelBuilder(separator, (JAXXContext)context, null, null);
        NavigationTreeNode rootNode = builder.build(null, (String)null, (String)null, ROOT_CONTEXT, null, null);
        builder.build(rootNode, (String)null, Util.newContextEntryDef((String)"name", String.class), "name", null, null);
        builder.build(rootNode, (String)null, Util.newContextEntryDef((String)"name2", String.class), "name2", null, null);
        NavigationTreeNode sonNode = builder.build(rootNode, (String)null, Util.newContextEntryDef(Model.class), "model", null, null);
        builder.build(sonNode, (String)null, "../name", "name", null, null);
        builder.build(sonNode, (String)null, "../integerValue", "integerValue", null, null);
        NavigationTreeNode sonSonNode = builder.build(sonNode, (String)null, "../sons", "sons", null, null);
        NavigationTreeNode sonSonSonNode = builder.build(sonSonNode, (String)null, "..[1]", "0", null, null);
        builder.build(sonSonSonNode, (String)null, "../name", "name", null, null);
        builder.build(sonSonSonNode, (String)null, "../integerValue", "integerValue", null, null);
        builder.build(sonSonSonNode, (String)null, "../sons", "sons", null, null);
        sonSonSonNode = builder.build(sonSonNode, (String)null, "..[2]", "1", null, null);
        builder.build(sonSonSonNode, (String)null, "../name", "name", null, null);
        builder.build(sonSonSonNode, (String)null, "../integerValue", "integerValue", null, null);
        builder.build(sonSonSonNode, (String)null, "../sons", "sons", null, null);
        sonSonSonNode = builder.build(sonSonNode, (String)null, (String)null, "2", null, null);
        sonSonNode.insert((MutableTreeNode)sonSonSonNode, 2);
        builder.build(sonSonSonNode, (String)null, "../..[3]/name", "name", null, null);
        builder.build(sonSonSonNode, (String)null, "../..[3]/integerValue", "integerValue", null, null);
        builder.build(sonSonSonNode, (String)null, "../..[3]/sons", "sons", null, null);
        NavigationTreeModel model = builder.getModel();
        Assert.assertNull((Object)model.getBean("$root.name-fake"));
        this.testBinding(model, (JAXXContext)context, "$root/name", context.getContextValue(String.class, "name"));
        this.testBinding(model, (JAXXContext)context, "$root/name2", context.getContextValue(String.class, "name2"));
        Model bean = (Model)context.getContextValue(Model.class);
        this.testBinding(model, (JAXXContext)context, "$root/model", bean);
        this.testBinding(model, (JAXXContext)context, "$root/model/name", bean.getName());
        this.testBinding(model, (JAXXContext)context, "$root/model/integerValue", bean.getIntegerValue());
        this.testBinding(model, (JAXXContext)context, "$root/model/sons", bean.getSons());
        this.testBinding(model, (JAXXContext)context, "$root/model/sons/0/name", bean.getSons().get(0).getName());
        this.testBinding(model, (JAXXContext)context, "$root/model/sons/0/integerValue", bean.getSons().get(0).getIntegerValue());
        this.testBinding(model, (JAXXContext)context, "$root/model/sons/0/sons", bean.getSons().get(0).getSons());
        this.testBinding(model, (JAXXContext)context, "$root/model/sons/1/name", bean.getSons().get(1).getName());
        this.testBinding(model, (JAXXContext)context, "$root/model/sons/1/integerValue", bean.getSons().get(1).getIntegerValue());
        this.testBinding(model, (JAXXContext)context, "$root/model/sons/1/sons", bean.getSons().get(1).getSons());
        this.testBinding(model, (JAXXContext)context, "$root/model/sons/2/name", bean.getSons().get(2).getName());
        this.testBinding(model, (JAXXContext)context, "$root/model/sons/2/integerValue", bean.getSons().get(2).getIntegerValue());
        this.testBinding(model, (JAXXContext)context, "$root/model/sons/2/sons", bean.getSons().get(2).getSons());
    }

    @Test
    public void testGetBeanFromList() throws Exception {
        List<Model> list = Arrays.asList(new Model("entryOne", 10, Arrays.asList(new Model("one", 1, Collections.<Model>emptyList()), new Model("two", 2, Collections.<Model>emptyList()), new Model("three", 3, Collections.<Model>emptyList()))), new Model("entryTwo", 20, Arrays.asList(new Model("2one", 1, Collections.<Model>emptyList()), new Model("2two", 2, Collections.<Model>emptyList()), new Model("2three", 3, Collections.<Model>emptyList()))), new Model("entryThree", 30, Arrays.asList(new Model("3one", 1, Collections.<Model>emptyList()), new Model("3two", 2, Collections.<Model>emptyList()), new Model("3three", 3, Collections.<Model>emptyList()))));
        DefaultJAXXContext context = new DefaultJAXXContext();
        context.setContextValue(list, "models");
        NavigationTreeModelBuilder builder = new NavigationTreeModelBuilder(separator, (JAXXContext)context, null, null);
        NavigationTreeNode rootNode = builder.build(null, (String)null, (String)null, ROOT_CONTEXT, null, null);
        NavigationTreeNode sonNode = builder.build(rootNode, (String)null, Util.newListContextEntryDef((String)"models"), "models", null, null);
        NavigationTreeNode sonSonNode = builder.build(sonNode, (String)null, "..[1]", "0", null, null);
        builder.build(sonSonNode, (String)null, "../name", "name", null, null);
        builder.build(sonSonNode, (String)null, "../integerValue", "integerValue", null, null);
        sonSonNode = builder.build(sonSonNode, (String)null, "../sons", "sons", null, null);
        NavigationTreeNode sonSonSonNode = builder.build(sonSonNode, (String)null, "..[1]", "0", null, null);
        builder.build(sonSonSonNode, (String)null, "../name", "name", null, null);
        sonSonNode = builder.build(sonNode, (String)null, "..[2]", "1", null, null);
        builder.build(sonSonNode, (String)null, "../name", "name", null, null);
        builder.build(sonSonNode, (String)null, "../integerValue", "integerValue", null, null);
        builder.build(sonSonNode, (String)null, "../sons", "sons", null, null);
        sonSonNode = builder.build(sonNode, (String)null, "..[3]", "2", null, null);
        builder.build(sonSonNode, (String)null, "../name", "name", null, null);
        builder.build(sonSonNode, (String)null, "../integerValue", "integerValue", null, null);
        builder.build(sonSonNode, (String)null, "../sons", "sons", null, null);
        NavigationTreeModel model = builder.getModel();
        this.testBinding(model, (JAXXContext)context, "$root/models", list);
        Model bean = list.get(0);
        this.testBinding(model, (JAXXContext)context, "$root/models/0", bean);
        this.testBinding(model, (JAXXContext)context, "$root/models/0/name", bean.getName());
        this.testBinding(model, (JAXXContext)context, "$root/models/0/integerValue", bean.getIntegerValue());
        this.testBinding(model, (JAXXContext)context, "$root/models/0/sons", bean.getSons());
        this.testBinding(model, (JAXXContext)context, "$root/models/0/sons/0", bean.getSons().get(0));
        this.testBinding(model, (JAXXContext)context, "$root/models/0/sons/0/name", bean.getSons().get(0).getName());
        bean = list.get(1);
        this.testBinding(model, (JAXXContext)context, "$root/models/1", bean);
        this.testBinding(model, (JAXXContext)context, "$root/models/1/name", bean.getName());
        this.testBinding(model, (JAXXContext)context, "$root/models/1/integerValue", bean.getIntegerValue());
        this.testBinding(model, (JAXXContext)context, "$root/models/1/sons", bean.getSons());
        bean = list.get(2);
        this.testBinding(model, (JAXXContext)context, "$root/models/2", bean);
        this.testBinding(model, (JAXXContext)context, "$root/models/2/name", bean.getName());
        this.testBinding(model, (JAXXContext)context, "$root/models/2/integerValue", bean.getIntegerValue());
        this.testBinding(model, (JAXXContext)context, "$root/models/2/sons", bean.getSons());
    }

    protected void testBinding(NavigationTreeModel model, JAXXContext context, String contextPath, Object expected) throws Exception {
        Object value = model.getBean(contextPath);
        Assert.assertNotNull((String)("could not find bean for path : " + contextPath), (Object)value);
        Assert.assertEquals((Object)expected, (Object)value);
    }

    protected String getNodeContext(int ... context) {
        String result = "";
        for (int i : context) {
            result = result + i;
        }
        return result;
    }

    protected void assertNodeEquals(String contextPath, String nodeContext, int level, NavigationTreeNode node, boolean root) {
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)root, (Object)node.isRoot());
        Assert.assertEquals((long)level, (long)node.getLevel());
        Assert.assertEquals((Object)nodeContext, (Object)node.getNodePath());
        Assert.assertEquals((Object)contextPath, (Object)node.getFullPath());
    }

    public static class Model {
        protected String name;
        protected int integerValue;
        protected List<Model> sons;

        public Model(String name, int integerValue, List<Model> sons) {
            this.name = name;
            this.integerValue = integerValue;
            this.sons = sons;
        }

        public String getName() {
            return this.name;
        }

        public int getIntegerValue() {
            return this.integerValue;
        }

        public List<Model> getSons() {
            return this.sons;
        }

        public String toString() {
            return super.toString() + "<name:" + this.name + ",integerValue:" + this.integerValue + ",sons: " + this.sons + ">";
        }
    }
}

