/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.decorator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jaxx.runtime.decorator.Data;
import jaxx.runtime.decorator.DecoratorUtils;
import jaxx.runtime.decorator.JXPathDecorator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class JXPathDecoratorTest {
    protected JXPathDecorator<?> decorator;
    protected String expected;
    protected String result;

    @After
    public void after() {
        this.decorator = null;
    }

    @Test(expected=NullPointerException.class)
    public void testNullInternalClass() throws Exception {
        this.decorator = DecoratorUtils.newJXPathDecorator(null, (String)"hello");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingRightBrace() throws Exception {
        this.decorator = DecoratorUtils.newJXPathDecorator(Object.class, (String)"${haha");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingRightBrace2() throws Exception {
        this.decorator = DecoratorUtils.newJXPathDecorator(Object.class, (String)"${haha${hum}");
    }

    @Test
    public void testNullBean() throws Exception {
        this.decorator = DecoratorUtils.newJXPathDecorator(Object.class, (String)"hello");
        this.expected = "hello";
        Assert.assertEquals((Object)this.expected, (Object)this.decorator.getExpression());
        Assert.assertEquals((long)0L, (long)this.decorator.nbToken);
        Assert.assertEquals((long)0L, (long)this.decorator.getTokens().length);
        this.result = this.decorator.toString(null);
        Assert.assertEquals(null, (Object)this.result);
    }

    @Test
    public void testNoJXPath() throws Exception {
        this.decorator = DecoratorUtils.newJXPathDecorator(Object.class, (String)"hello");
        this.expected = "hello";
        Assert.assertEquals((Object)this.expected, (Object)this.decorator.getExpression());
        Assert.assertEquals((long)0L, (long)this.decorator.nbToken);
        Assert.assertEquals((long)0L, (long)this.decorator.getTokens().length);
        this.result = this.decorator.toString((Object)this);
        Assert.assertEquals((Object)this.expected, (Object)this.result);
    }

    @Test
    public void testDecorator() throws Exception {
        this.decorator = DecoratorUtils.newJXPathDecorator(JXPathDecorator.class, (String)"${expression}$s - ${nbToken}$d");
        Assert.assertEquals((Object)"%1$s - %2$d", (Object)this.decorator.getExpression());
        this.assertDecoratorInternal(new String[0]);
        this.decorator = DecoratorUtils.newJXPathDecorator(JXPathDecorator.class, (String)"${expression}${nbToken}");
        Assert.assertEquals((Object)"%1%2", (Object)this.decorator.getExpression());
        this.assertDecoratorInternal(new String[0]);
        this.decorator = DecoratorUtils.newJXPathDecorator(JXPathDecorator.class, (String)"before ${expression}$s - ${nbToken}$d after");
        Assert.assertEquals((Object)"before %1$s - %2$d after", (Object)this.decorator.getExpression());
        this.assertDecoratorInternal(new String[0]);
        this.decorator = DecoratorUtils.newJXPathDecorator(JXPathDecorator.class, (String)"before${expression}$s-${nbToken}$dafter");
        Assert.assertEquals((Object)"before%1$s-%2$dafter", (Object)this.decorator.getExpression());
        this.assertDecoratorInternal(new String[0]);
    }

    @Test
    public void testSort() throws Exception {
        List<Data> datas = Data.generate(10);
        JXPathDecorator d = DecoratorUtils.newJXPathDecorator(Data.class, (String)"${pos}$d ${name}$s");
        ArrayList<Data> sortData = new ArrayList<Data>(datas);
        DecoratorUtils.sort((JXPathDecorator)d, sortData, (int)0);
        for (int i = 0; i < datas.size(); ++i) {
            Data data = datas.get(i);
            Data sData = (Data)sortData.get(i);
            Assert.assertEquals((Object)data, (Object)sData);
        }
        Collections.sort(datas, new Comparator<Data>(){

            @Override
            public int compare(Data o1, Data o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        JXPathDecorator.Context context = d.context;
        context.setComparator(null);
        DecoratorUtils.sort((JXPathDecorator)d, sortData, (int)1);
        for (int i = 0; i < datas.size(); ++i) {
            Data data = datas.get(i);
            Data sData = (Data)sortData.get(i);
            Assert.assertEquals((Object)data, (Object)sData);
        }
    }

    public void assertDecoratorInternal(String ... tokens) {
        this.assertTokens(tokens);
        this.expected = String.format(this.decorator.getExpression(), this.decorator.getExpression(), this.decorator.getNbToken());
        this.result = this.decorator.toString(this.decorator);
        Assert.assertEquals((Object)this.expected, (Object)this.result);
    }

    private void assertTokens(String ... tokens) {
        if (tokens.length == 0) {
            tokens = new String[]{"expression", "nbToken"};
        }
        Assert.assertEquals((long)2L, (long)this.decorator.nbToken);
        Assert.assertEquals((long)2L, (long)this.decorator.getTokens().length);
        Assert.assertEquals((Object)tokens[0], (Object)this.decorator.getTokens()[0]);
        Assert.assertEquals((Object)tokens[1], (Object)this.decorator.getTokens()[1]);
    }
}

