/*
 * *##% 
 * JAXX Runtime
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.runtime.validator.swing;

import javax.swing.JComponent;
import jaxx.runtime.validator.BeanValidatorField;
import jaxx.runtime.validator.BeanValidatorMessage;
import jaxx.runtime.validator.BeanValidatorScope;

/**
 * The object to box a validation message within an u.
 *
 * @author chemit
 * @since 1.3
 * @see BeanValidatorMessage
 */
public class SwingValidatorMessage extends BeanValidatorMessage<SwingValidatorMessage> {

    /**
     * the optional field's editor
     */
    protected JComponent editor;
    protected String fieldName;

    public SwingValidatorMessage(SwingValidator<?> validator, BeanValidatorField<?> field, String message, BeanValidatorScope scope, JComponent editor) {
        super(validator, field, message, scope);
        this.fieldName = field.getName();
        this.editor = editor;
    }

    public SwingValidatorMessage(SwingValidator<?> validator, String fieldName, String message, BeanValidatorScope scope, JComponent editor) {
        super(validator, null, message, scope);
        this.fieldName = fieldName;
        this.editor = editor;
    }

    public JComponent getEditor() {
        return editor;
    }

    public String getFieldName() {
        return fieldName;
    }

    @Override
    public int compareTo(SwingValidatorMessage o) {
        // sort on scope
        int result = getScope().compareTo(o.getScope());
        if (result == 0) {
            // sort on field name
            result = fieldName.compareTo(o.getFieldName());
            if (result == 0) {
                // sort on message
                result = message.compareTo(o.getMessage());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String s = scope + " - " + (field == null ? message : field.getI18nError(message));
        if (editor == null) {
            return s;
        }
        return editor.getName() + " : " + s;
    }
}
