/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime;

import java.awt.Container;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import jaxx.runtime.DefaultJAXXContext;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DataContext {
    private static Log log = LogFactory.getLog(DataContext.class);
    protected final DefaultJAXXContext delegate;
    protected DataContextEntry<?> currentEntry;
    protected final PropertyChangeSupport pcs;
    protected DataContextEntry<?>[] entries;
    protected final String[] DEFAULT_JAXX_PCS;

    public abstract String getContextPath(Object ... var1);

    public DataContext(String[] DEFAULT_JAXX_PCS, DataContextEntry<?>[] entries) {
        this.DEFAULT_JAXX_PCS = DEFAULT_JAXX_PCS;
        this.entries = entries;
        this.delegate = new DefaultJAXXContext(){

            @Override
            protected void setUi(JAXXObject ui) {
                throw new IllegalStateException("can not use this method for this type of context");
            }

            @Override
            public <O extends Container> O getParentContainer(Class<O> clazz) {
                throw new IllegalStateException("can not use this method for this type of context");
            }

            @Override
            public <O extends Container> O getParentContainer(Object top, Class<O> clazz) {
                throw new IllegalStateException("can not use this method for this type of context");
            }

            @Override
            protected JAXXObject getUi() {
                throw new IllegalStateException("can not use this method for this type of context");
            }

            @Override
            protected void setParentContext(JAXXContext parentContext) {
                throw new IllegalStateException("can not use this method for this type of context");
            }

            @Override
            protected JAXXContext getParentContext() {
                return null;
            }

            @Override
            public <T> void removeContextValue(Class<T> klazz, String name) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)(klazz + " - " + name));
                }
                super.removeContextValue(klazz, name);
            }

            @Override
            public <T> void setContextValue(T o, String name) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)(name + " - " + o.getClass()));
                }
                super.setContextValue(o, name);
            }
        };
        this.pcs = new PropertyChangeSupport(this);
    }

    public DefaultJAXXContext getDelegate() {
        return this.delegate;
    }

    public Iterable<? extends DataContextEntry<?>> iterateOnAll() {
        return new Iterable<DataContextEntry<?>>(){

            @Override
            public Iterator<DataContextEntry<?>> iterator() {
                return new DataContextEntryIterator(DataContext.this.entries);
            }
        };
    }

    public Iterable<? extends DataContextEntry<?>> iterateToLevel(final int level) {
        return new Iterable<DataContextEntry<?>>(){

            @Override
            public Iterator<DataContextEntry<?>> iterator() {
                return new DataContextEntryIterator((DataContextEntry[])DataContext.this.entries, level);
            }
        };
    }

    public Iterable<? extends DataContextEntry<?>> reverseIterateOnAll() {
        return new Iterable<DataContextEntry<?>>(){

            @Override
            public Iterator<DataContextEntry<?>> iterator() {
                return new DataContextEntryIterator((DataContextEntry[])DataContext.this.entries, true);
            }
        };
    }

    public DataContextEntry<?> getCurrentEntry() {
        return this.currentEntry;
    }

    public DataContextEntry<?> getEntry(String path) {
        for (DataContextEntry<?> scope : this.reverseIterateOnAll()) {
            if (!scope.acceptPath(path)) continue;
            return scope;
        }
        return null;
    }

    public DataContextEntry<?> getEntry(Class<?> type) {
        for (DataContextEntry<?> scope : this.iterateOnAll()) {
            if (!scope.acceptType(type)) continue;
            return scope;
        }
        return null;
    }

    public <T> T getContextValue(DataContextEntry<T> entry, String key) {
        String contextKey = this.getKey(entry, key);
        T result = this.delegate.getContextValue(entry.getKlass(), contextKey);
        return result;
    }

    public void setContextValue(DataContextEntry entry, Object value, String key) {
        String contextKey = this.getKey(entry, key);
        this.delegate.setContextValue(value, contextKey);
    }

    public void removeContextValue(DataContextEntry entry, Object value, String key) {
        String contextKey = this.getKey(entry, key);
        this.delegate.removeContextValue(value.getClass(), contextKey);
    }

    public void updateSelectedData(String path, Object data, UpdateDataContext updator) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"----------------------------------------------------------------");
        }
        if (this.currentEntry != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("remove from old entry " + this.currentEntry));
            }
            for (DataContextEntry<?> s : this.currentEntry) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("remove entry " + s));
                }
                updator.onRemovingData(this, s);
            }
        }
        this.currentEntry = this.getEntry(path);
        if (log.isDebugEnabled()) {
            log.debug((Object)("new entry " + this.currentEntry + " for path " + path));
        }
        if (this.currentEntry != null) {
            for (DataContextEntry<?> s : this.iterateToLevel(this.currentEntry.getLevel())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("add entry " + s));
                }
                updator.onAddingData(this, s, path);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized boolean hasListeners(String propertyName) {
        return this.pcs.hasListeners(propertyName);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public void removeJaxxPropertyChangeListener() {
        PropertyChangeListener[] toRemove = Util.findJaxxPropertyChangeListener(this.DEFAULT_JAXX_PCS, this.getPropertyChangeListeners());
        if (toRemove == null || toRemove.length == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("before remove : " + this.getPropertyChangeListeners().length));
            log.debug((Object)("toRemove : " + toRemove.length));
        }
        for (PropertyChangeListener listener : toRemove) {
            this.removePropertyChangeListener(listener);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("after remove : " + this.getPropertyChangeListeners().length));
        }
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(name, oldValue, newValue);
    }

    protected String getKey(DataContextEntry entry, String key) {
        String result = null;
        if (key != null) {
            result = entry.hashCode() + "#" + key;
        }
        return result;
    }

    public void close() throws Exception {
        this.clear();
        for (PropertyChangeListener l : this.getPropertyChangeListeners()) {
            this.removePropertyChangeListener(l);
        }
    }

    public void clear() {
        this.delegate.clear();
    }

    public static class DataContextEntryIterator
    implements Iterator<DataContextEntry<?>> {
        protected final DataContextEntry[] datas;
        protected final boolean reverse;
        protected final int level;
        protected int index;

        public DataContextEntryIterator(DataContextEntry[] datas) {
            this(datas, false, -1);
        }

        public DataContextEntryIterator(DataContextEntry[] datas, int level) {
            this(datas, false, level);
        }

        public DataContextEntryIterator(DataContextEntry[] datas, boolean reverse) {
            this(datas, reverse, -1);
        }

        DataContextEntryIterator(DataContextEntry[] datas, boolean reverse, int level) {
            this.datas = datas;
            this.reverse = reverse;
            this.index = reverse ? datas.length : -1;
            this.level = level;
        }

        @Override
        public boolean hasNext() {
            if (this.reverse) {
                return this.index > 0;
            }
            return this.index + 1 < this.datas.length && (this.level == -1 || this.datas[this.index + 1].getLevel() <= this.level);
        }

        @Override
        public DataContextEntry<?> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.index = this.reverse ? --this.index : ++this.index;
            return this.datas[this.index];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static interface UpdateDataContext<D extends DataContext> {
        public void onRemovingData(D var1, DataContextEntry<?> var2);

        public void onAddingData(D var1, DataContextEntry var2, String var3);
    }

    public static abstract class DataContextEntry<E>
    implements Iterable<DataContextEntry<?>> {
        private final int level;
        private final DataContextEntry<?> previous;
        private final DataContextEntry[] parents;
        private Class<E> klass;

        public DataContextEntry(Class<E> klass, DataContextEntry<?> previous) {
            this.previous = previous;
            this.level = previous.level + 1;
            this.klass = klass;
            this.parents = new DataContextEntry[this.level];
            int i = this.level;
            while (i > 0) {
                this.parents[--i] = previous;
                previous = previous.previous;
            }
        }

        public DataContextEntry(Class<E> klass) {
            this.level = 0;
            this.klass = klass;
            this.previous = null;
            this.parents = new DataContextEntry[0];
        }

        public Class<E> getKlass() {
            return this.klass;
        }

        public int getLevel() {
            return this.level;
        }

        public DataContextEntry[] getParents() {
            return this.parents;
        }

        public abstract Pattern getPattern();

        public abstract String getContextPath(Object ... var1);

        public boolean acceptPath(String path) {
            return this.getPattern().matcher(path).matches();
        }

        public boolean acceptType(Class<?> type) {
            return this.klass.isAssignableFrom(type);
        }

        @Override
        public Iterator<DataContextEntry<?>> iterator() {
            int length = this.parents.length;
            DataContextEntry[] t = new DataContextEntry[length + 1];
            System.arraycopy(this.parents, 0, t, 0, length);
            t[length] = this;
            return new DataContextEntryIterator(t, true);
        }

        public String toString() {
            return super.toString() + "<type: " + this.klass.getSimpleName() + ">";
        }
    }
}

