package jaxx.runtime.swing.config;

/*-
 * #%L
 * JAXX :: Config
 * %%
 * Copyright (C) 2008 - 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneConstants;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.config.model.CategoryModel;
import jaxx.runtime.swing.config.model.ConfigTableModel;
import jaxx.runtime.swing.config.model.ConfigUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n.t;

public class ConfigCategoryUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CATEGORY_MODEL = "categoryModel";
    public static final String PROPERTY_SELECTION_MODEL = "selectionModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_RESET_ENABLED = "reset.enabled";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_TABLE_PANE_COLUMN_HEADER_VIEW = "tablePane.columnHeaderView";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWTU8bRxgeHAwBQkJxQxKRpIZUqanKGtLm0CZqY1wQRgYj2yQpHOjYO9iTjHc2s7PBxErVn9Cf0N57qdRbT1Uq9ZxDL1H/QlX10GvVd2bXu168BEfhsKxn3/eZ5/16Zn78CyUdgeYe4XbbEK4laYsYG7mHD0u1R6QuvyROXVBbcoG8v6EESuyhCTNYdyS6sVdU7lnfPZvnLZtbxOrxvlNE4448YsRpEiIluhb1qDtOthJ8vtO2XdFFDUjFoX7/z9+J78xvf0gg1LaBXQpCSZ/mFUYyXEQJako0DTs9xVmGrQbQENRqAN9JtZZn2HG2cIs8Qd+g0SIasbEAMInmBw9ZY2j/ti3R2fc3trFF2JJEH0aYOoewr1Hn1gFtAG31L48laXBxtFOwbY0wItFoE1smI0Ki5cHd1z2fECXZ4iZhEi2ejKEtfKSdwqb6FfpP1n3szUFxeu1DnHGJa4z4IEuDkakGLiHOeYcwaFfKLR/ruqpe2wcpUkdWIgah53Q3kiKuEaZLA4u93l69lPlYf/za67iDXlSWs4HDmA5UIUl0KWJcqQvO9MbRLZLaQ6JZLhrGIxi4x5LbnlPb2Hios6BM5wKPbmstq9/XomgXuhMLGejudUM9PghMJnpMJLoYIVklbZkTBCvThb4NbwUbhmhJQRw16akIzoorJbeUiRFYDjv4qeZzK7ru9cY2t10Ym5loRdTiJrHc3o7k9lGeMHYfM5cc569sC5K0lPHtwGdKcyzpiLWbWv/MtxFoNtKPoFFGqFGhiAztQawuLEt0ea9f1srwyRO0y8cETQHqr//NpP745c+f17oqNg17X4w17RFhUBdbcBuEgKqtL3gS5krKspvYvrOHxryR0Ap9NYZYxf8M5GC/d5S7odyNdew0ASI5+urXFzNfvzyDEmtonHFsrmFlX4BebkLimpyZbfuLe5rRucOz8JxS3KBwNVx/3BDctUBbJzt5zrgwHqwXqqvP25CHqzF5CMjUxn7/N1X56V43F0PA7cqJ5mE+krtohFqMWkRrui/XsRo+YTvENXkoy3FCjWKVwfb7bUU/1+KCn6pz5rasdYJNIu5TcijRbscih2lPFTIyM+9rWs+4zS98lK6oTt1RBWgQCYKLLdwgIqc1qwAumXlqHXDRwl2H5aUFyKcisqETpd6KqH/UTyOdhEEmJvXlJnmAGQwFGjsAFVh06DN4Tywv6YW660SNhiXogkTpThiVxQ2utza8/iPm/MJzsBT8EBpx6OM4xr3KcxrbM7EpvtzR9FXqtDB63zJq50tP1YzUMfOEdgWLbc5o/UiibCfUXjhaHIkt6Rj3V8vVQj5X3K/ky6VicSVX3s8VH+S+qgDWlSYX9BkkJgZtKRZtvVQu7Ja2qhG8rVXYJLZ24TExQNX6Dr2pTnQFGJ/HruRlouqoliSa6/hnh5HbqZb2y6uVwu4qRFjcz5eKO5tbKswUFCs4L3OM8UNihkVPKcg8HAaSlMGOC6luI8NSKNkdA9d1QhtNaIvErdtxMXoH22nxDYOO4KD5JTrn9deif6z4nZfyu86zNPyPE5JzVqV2VdtcirExJHQbGiWWomKqrEDnRO4omQWDOvBGDygxM/GT5p1xbxrJhB+JOvaCQKajJL1v0Thm+k2Oh5E7LYz0zZvpWBM4/uhJYeoDeoC5nKxxAVO3jaklextmhNv4iRvRFjhOInoTt+05bVGFFMCUDaC8Sebdxd718+QpgpctJ26DngvGANHF1lBdOoIazkYLdOxCEi3me6+xVVWN4xu94rwp5VTvAC1y/5rnU78eMyM996Lj7Odfb35SAH33rQGqOsLwEYdbIzp/14SeSdeoZcJB+Xkf/pB6jp+KqJZfqMdv8QiZt0bIDhDVMK171+ATMJYHYvHyNQifvDXCp2+NcBcQ/gevoEb3YRAAAA==";
    private static final Log log = LogFactory.getLog(ConfigCategoryUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel categoryLabel;
    protected JPanel categoryLabelPanel;
    protected CategoryModel categoryModel;
    protected JMenuItem copyCellValue;
    protected JTextArea description;
    protected JScrollPane descriptionPane;
    protected ConfigCategoryUIHandler handler;
    protected ConfigUIModel model;
    protected JButton reset;
    protected JMenuItem resetOptionValue;
    protected JButton save;
    protected ListSelectionModel selectionModel;
    protected JXTable table;
    protected ConfigTableModel tableModel;
    protected JScrollPane tablePane;
    protected JPopupMenu tablePopup;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ConfigCategoryUI $JPanel0 = this;
    private JPanel $JPanel1;
    private JPanel $JPanel2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
      getHandler().init();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ConfigCategoryUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCategoryUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCategoryUI() {
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCategoryUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__copyCellValue(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.copyCellValue();
    }

    public void doActionPerformed__on__reset(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.reset();
    }

    public void doActionPerformed__on__resetOptionValue(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.resetOptionValue();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.saveModified();
    }

    public void doMousePressed__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openTablePopupMenu(event, tablePopup);
    }

    public void doTableChanged__on__tableModel(TableModelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateDescriptionText();
    }

    public void doValueChanged__on__selectionModel(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (!event.getValueIsAdjusting()) {handler.updateDescriptionText(); }
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getCategoryLabel() {
        return categoryLabel;
    }

    public JPanel getCategoryLabelPanel() {
        return categoryLabelPanel;
    }

    public CategoryModel getCategoryModel() {
        return categoryModel;
    }

    public JMenuItem getCopyCellValue() {
        return copyCellValue;
    }

    public JTextArea getDescription() {
        return description;
    }

    public JScrollPane getDescriptionPane() {
        return descriptionPane;
    }

    public ConfigCategoryUIHandler getHandler() {
        return handler;
    }

    public ConfigUIModel getModel() {
        return model;
    }

    public JButton getReset() {
        return reset;
    }

    public JMenuItem getResetOptionValue() {
        return resetOptionValue;
    }

    public JButton getSave() {
        return save;
    }

    public ListSelectionModel getSelectionModel() {
        return selectionModel;
    }

    public JXTable getTable() {
        return table;
    }

    public ConfigTableModel getTableModel() {
        return tableModel;
    }

    public JScrollPane getTablePane() {
        return tablePane;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setCategoryModel(CategoryModel categoryModel) {
        CategoryModel oldValue = this.categoryModel;
        this.categoryModel = categoryModel;
        firePropertyChange(PROPERTY_CATEGORY_MODEL, oldValue, categoryModel);
    }

    public void setSelectionModel(ListSelectionModel selectionModel) {
        ListSelectionModel oldValue = this.selectionModel;
        this.selectionModel = selectionModel;
        firePropertyChange(PROPERTY_SELECTION_MODEL, oldValue, selectionModel);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCategoryLabelPanel() {
        if (!allComponentsCreated) {
            return;
        }
        categoryLabelPanel.add(categoryLabel);
    }

    protected void addChildrenToDescriptionPane() {
        if (!allComponentsCreated) {
            return;
        }
        descriptionPane.getViewport().add(description);
    }

    protected void addChildrenToTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        tablePane.getViewport().add(table);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(copyCellValue);
        tablePopup.add(resetOptionValue);
    }

    protected void createCategoryLabel() {
        $objectMap.put("categoryLabel", categoryLabel = new JLabel());
        
        categoryLabel.setName("categoryLabel");
    }

    protected void createCategoryLabelPanel() {
        $objectMap.put("categoryLabelPanel", categoryLabelPanel = new JPanel());
        
        categoryLabelPanel.setName("categoryLabelPanel");
    }

    protected void createCategoryModel() {
        $objectMap.put("categoryModel", categoryModel = getContextValue(CategoryModel.class));
    }

    protected void createCopyCellValue() {
        $objectMap.put("copyCellValue", copyCellValue = new JMenuItem());
        
        copyCellValue.setName("copyCellValue");
        copyCellValue.setText(t("config.action.copyCellValue"));
        copyCellValue.setToolTipText(t("config.action.copyCellValue.tip"));
        copyCellValue.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__copyCellValue"));
    }

    protected void createDescription() {
        $objectMap.put("description", description = new JTextArea());
        
        description.setName("description");
        description.setColumns(15);
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        description.setEditable(false);
        if (description.getFont() != null) {
            description.setFont(description.getFont().deriveFont((float) 10));
        }
        description.setFocusable(false);
        description.setRows(3);
    }

    protected void createDescriptionPane() {
        $objectMap.put("descriptionPane", descriptionPane = new JScrollPane());
        
        descriptionPane.setName("descriptionPane");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new ConfigCategoryUIHandler(this));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ConfigUIModel.class));
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new JButton());
        
        reset.setName("reset");
        reset.setText(t("config.action.reset"));
        reset.setToolTipText(t("config.action.reset.tip"));
        reset.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__reset"));
    }

    protected void createResetOptionValue() {
        $objectMap.put("resetOptionValue", resetOptionValue = new JMenuItem());
        
        resetOptionValue.setName("resetOptionValue");
        resetOptionValue.setText(t("config.action.resetOptionValue"));
        resetOptionValue.setToolTipText(t("config.action.resetOptionValue.tip"));
        resetOptionValue.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetOptionValue"));
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("config.action.save"));
        save.setToolTipText(t("config.action.save.tip"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createSelectionModel() {
        $objectMap.put("selectionModel", selectionModel = new DefaultListSelectionModel());
        
        selectionModel.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionModel"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable(tableModel));
        
        table.setName("table");
        table.setRowSelectionAllowed(false);
        table.setAutoCreateRowSorter(true);
        table.setRowHeight(25);
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mousePressed", this, "doMousePressed__on__table"));
    }

    protected void createTableModel() {
        $objectMap.put("tableModel", tableModel = new ConfigTableModel(categoryModel));
        
        tableModel.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__tableModel"));
    }

    protected void createTablePane() {
        $objectMap.put("tablePane", tablePane = new JScrollPane());
        
        tablePane.setName("tablePane");
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("config.table.actions");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(categoryLabelPanel, BorderLayout.NORTH);
        add(tablePane, BorderLayout.CENTER);
        add($JPanel1, BorderLayout.SOUTH);
        addChildrenToCategoryLabelPanel();
        addChildrenToTablePane();
        // inline complete setup of $JPanel1
        $JPanel1.add(descriptionPane, BorderLayout.CENTER);
        $JPanel1.add($JPanel2, BorderLayout.SOUTH);
        addChildrenToDescriptionPane();
        // inline complete setup of $JPanel2
        $JPanel2.add(reset);
        $JPanel2.add(save);
        addChildrenToTablePopup();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        categoryLabelPanel.setBackground(Color.WHITE);
        tablePane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        tablePane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        table.setSelectionModel(selectionModel);
        table.setAutoResizeMode(JXTable.AUTO_RESIZE_ALL_COLUMNS);
        descriptionPane.setColumnHeaderView(new JLabel(t("config.description"), SwingUtil.getUIManagerActionIcon("information"), 10));
        SwingUtil.setText(description, t("config.no.option.selected"));
        
        reset.setIcon(SwingUtil.createActionIcon("config-reset"));
        save.setIcon(SwingUtil.createActionIcon("config-save"));
        copyCellValue.setIcon(SwingUtil.createActionIcon("config-copy"));
        resetOptionValue.setIcon(SwingUtil.createActionIcon("config-reset-option"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        createModel();
        createCategoryModel();
        createTableModel();
        createSelectionModel();
        createCategoryLabelPanel();
        createCategoryLabel();
        createTablePane();
        createTable();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createDescriptionPane();
        createDescription();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createReset();
        createSave();
        createTablePopup();
        createCopyCellValue();
        createResetOptionValue();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_PANE_COLUMN_HEADER_VIEW, true) {
        
            @Override
            public void applyDataBinding() {
                if (table != null) {
                    table.addPropertyChangeListener("tableHeader", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (table != null) {
                    tablePane.setColumnHeaderView(table.getTableHeader());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (table != null) {
                    table.removePropertyChangeListener("tableHeader", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESET_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().addPropertyChangeListener("modified", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getCategoryModel() != null) {
                    reset.setEnabled(getCategoryModel().isModified());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().removePropertyChangeListener("modified", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().addPropertyChangeListener("modified", this);
                }
                if (getCategoryModel() != null) {
                    getCategoryModel().addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getCategoryModel() != null) {
                    save.setEnabled(getCategoryModel().isModified() && getCategoryModel().isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().removePropertyChangeListener("modified", this);
                }
                if (getCategoryModel() != null) {
                    getCategoryModel().removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}