package jaxx.runtime.swing.config;

/*
 * #%L
 * JAXX :: Config
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneConstants;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.config.model.CategoryModel;
import jaxx.runtime.swing.config.model.ConfigTableModel;
import jaxx.runtime.swing.config.model.ConfigUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n.t;

public class ConfigCategoryUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CATEGORY_MODEL = "categoryModel";
    public static final String PROPERTY_SELECTION_MODEL = "selectionModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_RESET_ENABLED = "reset.enabled";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_TABLE_PANE_COLUMN_HEADER_VIEW = "tablePane.columnHeaderView";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz1MjRRRusoRfWXZXqAW22LUCq2uwZAJYXsRaN2ShEmogW0lgEQ7YyTRJs5PpsadDwqbW8k9Q/wK9e7HKmyfLg2cPXiz/Bcvy4NXydc9kJkMGE0sOIXS/73vfe93va775HcUdjpbOcbut8aYlaINou5mjo0LlnFTFU+JUObUF48j9GYmh2AlKGP66I9DDE13C0x48nWUNm1nE6kFv6mjKEZcmceqECIEehBFVx0mX/O3Ntt3kXVZfVBTrV3/+Efvc+OzrGEJtG9TdgVKSg1BBJaM6ilFDoBnIdIHTJrZqIINTqwZ6p+Va1sSOs48b5BP0KRrX0ZiNOZAJtDx8yYpD4du2QBNv7D7DFjHXBHo7pNRpQV6tyqwzWgPZ8lcWC1Jj/PIgb9uKYUyg8Tq2DJNwgdaHh+dcTMASbzCDmAKtXs+hIjymg/ye/CvAT1c97r1heXrjA54pgSsm8UjWhhNT9iEBzy2HmHBdKbM8rtfl6bU9Ep06ohQKCJAz3Up0XCGmOhpY7EW75yXDJ/vrV6irALUoIxd9wKQqVDIJNB8KLlU5M1XicIq4Qgi0yHhNO4eBeyGY7YLa2u6R6oIMXfIR3au1Lv9+EGa73Z1Y6EA310P58ZYfkugJEehuSGSZtEWGEyxDV/oSbvgJA7Y4J46c9NkQz1ZTCGbJEM2PHHXwhdKz4a1ztBi6CeAOWuAOwfiOnECWJiwLtHDSbyhF2HKtZOGKlUhCtfv33Owv3//23U7XPxKQ+25kaI/9wVzbnNkwglSmvu2aR1NQM72H7c0TNOleRuWN9yOElbxtEAf5XpNwTcK1HHbqQBEf//WHH+c+/vkGiu2gKZNhYwfL+Dzcojq0tc5Mo21/+EQputmakMYntcE4VXD1RY2zpgWuNt3JMpNx7XkuX95+1YY+3I/ogy+mMvnTX7Olb590ezEC2u5dGx70I36MxqhlUosoN/WMMtI9E7ZDmgYLDDHKIlHkTNrexL6vPh9HFX+nysxmw8oRbBB+SElLoOOORVpJdx5TIrXsuUnPRV9eeSdZknfzQB5AjQiwOmzhGuEZ5RZ5gKSWqXXGeAN3AetrK9BPKWRLNUp+e4r6h2yQ6Dj4whmrNh130uNn2ISZQaMCpk2gZCdQbDGNKVrNvVvEWF55pdCWWHXoS0DF1uFJmSAGFVfYOGvBRRx5N0px78wPUnsjssULHZVPtk5ZkruXkurmL+SMVLHpWtwW5s+YSauXAqU7geuBqTsCW8LRDreL5Xw2o5+WssWCrm9liqcZ/XnmoxJw3aszTl9CtRFsa5FsuUIxf1zYL4f49rchSeTZBQY9qA+j8NzgpmBFIhsvnxOBljqeI2uZg3LhtLhdyh9vg3r9NFvQD/b2ZQmzcBD+K5QxTdYiRnBMk7CbI7RWh5OPbbwH4TJHFjxXkCIAGRfy0R8VvEmi9LvPxRDax4klIw0pGg4t9DCnVjTqwDd6RomhztC7i7PePcRKvOZ5+xT2Z0Sgm27IqreXEIyZZWqXFX4+Aq8JakdWonb/UyWZQZUkHz1KRoYcYpOGKp0JK5Vv05VCE16h7la4zrl+9HVlqmdvCFsbM/Elg2cT3frAwAInK9QywK8e93GOyM+pIRiv/LMk476MZntzIJtc/uJfGFL/myENDP8Aa23wfKYMAAA=";
    private static final Log log = LogFactory.getLog(ConfigCategoryUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel categoryLabel;
    protected JPanel categoryLabelPanel;
    protected CategoryModel categoryModel;
    protected JTextArea description;
    protected JScrollPane descriptionPane;
    protected ConfigCategoryUIHandler handler;
    protected ConfigUIModel model;
    protected JButton reset;
    protected JButton save;
    protected ListSelectionModel selectionModel;
    protected JXTable table;
    protected ConfigTableModel tableModel;
    protected JScrollPane tablePane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ConfigCategoryUI $JPanel0 = this;
    private JPanel $JPanel1;
    private JPanel $JPanel2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
      getHandler().init();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ConfigCategoryUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCategoryUI() {
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCategoryUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCategoryUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__reset(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.reset();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.saveModified();
    }

    public void doTableChanged__on__tableModel(TableModelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateDescriptionText();
    }

    public void doValueChanged__on__selectionModel(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (!event.getValueIsAdjusting()) {handler.updateDescriptionText(); }
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getCategoryLabel() {
        return categoryLabel;
    }

    public JPanel getCategoryLabelPanel() {
        return categoryLabelPanel;
    }

    public CategoryModel getCategoryModel() {
        return categoryModel;
    }

    public JTextArea getDescription() {
        return description;
    }

    public JScrollPane getDescriptionPane() {
        return descriptionPane;
    }

    public ConfigCategoryUIHandler getHandler() {
        return handler;
    }

    public ConfigUIModel getModel() {
        return model;
    }

    public JButton getReset() {
        return reset;
    }

    public JButton getSave() {
        return save;
    }

    public ListSelectionModel getSelectionModel() {
        return selectionModel;
    }

    public JXTable getTable() {
        return table;
    }

    public ConfigTableModel getTableModel() {
        return tableModel;
    }

    public JScrollPane getTablePane() {
        return tablePane;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setCategoryModel(CategoryModel categoryModel) {
        CategoryModel oldValue = this.categoryModel;
        this.categoryModel = categoryModel;
        firePropertyChange(PROPERTY_CATEGORY_MODEL, oldValue, categoryModel);
    }

    public void setSelectionModel(ListSelectionModel selectionModel) {
        ListSelectionModel oldValue = this.selectionModel;
        this.selectionModel = selectionModel;
        firePropertyChange(PROPERTY_SELECTION_MODEL, oldValue, selectionModel);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCategoryLabelPanel() {
        if (!allComponentsCreated) {
            return;
        }
        categoryLabelPanel.add(categoryLabel);
    }

    protected void addChildrenToDescriptionPane() {
        if (!allComponentsCreated) {
            return;
        }
        descriptionPane.getViewport().add(description);
    }

    protected void addChildrenToTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        tablePane.getViewport().add(table);
    }

    protected void createCategoryLabel() {
        $objectMap.put("categoryLabel", categoryLabel = new JLabel());
        
        categoryLabel.setName("categoryLabel");
    }

    protected void createCategoryLabelPanel() {
        $objectMap.put("categoryLabelPanel", categoryLabelPanel = new JPanel());
        
        categoryLabelPanel.setName("categoryLabelPanel");
    }

    protected void createCategoryModel() {
        $objectMap.put("categoryModel", categoryModel = getContextValue(CategoryModel.class));
    }

    protected void createDescription() {
        $objectMap.put("description", description = new JTextArea());
        
        description.setName("description");
        description.setColumns(15);
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        description.setFocusable(false);
        if (description.getFont() != null) {
            description.setFont(description.getFont().deriveFont((float) 10));
        }
        description.setEditable(false);
        description.setRows(3);
    }

    protected void createDescriptionPane() {
        $objectMap.put("descriptionPane", descriptionPane = new JScrollPane());
        
        descriptionPane.setName("descriptionPane");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new ConfigCategoryUIHandler(this));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ConfigUIModel.class));
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new JButton());
        
        reset.setName("reset");
        reset.setText(t("config.action.reset"));
        reset.setToolTipText(t("config.action.reset.tip"));
        reset.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__reset"));
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("config.action.save"));
        save.setToolTipText(t("config.action.save.tip"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createSelectionModel() {
        $objectMap.put("selectionModel", selectionModel = new DefaultListSelectionModel());
        
        selectionModel.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionModel"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable(tableModel));
        
        table.setName("table");
        table.setRowSelectionAllowed(false);
        table.setRowHeight(25);
        table.setAutoCreateRowSorter(true);
    }

    protected void createTableModel() {
        $objectMap.put("tableModel", tableModel = new ConfigTableModel(categoryModel));
        
        tableModel.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__tableModel"));
    }

    protected void createTablePane() {
        $objectMap.put("tablePane", tablePane = new JScrollPane());
        
        tablePane.setName("tablePane");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(categoryLabelPanel, BorderLayout.NORTH);
        add(tablePane, BorderLayout.CENTER);
        add($JPanel1, BorderLayout.SOUTH);
        addChildrenToCategoryLabelPanel();
        addChildrenToTablePane();
        // inline complete setup of $JPanel1
        $JPanel1.add(descriptionPane, BorderLayout.CENTER);
        $JPanel1.add($JPanel2, BorderLayout.SOUTH);
        addChildrenToDescriptionPane();
        // inline complete setup of $JPanel2
        $JPanel2.add(reset);
        $JPanel2.add(save);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        table.setSelectionModel(selectionModel);
        categoryLabelPanel.setBackground(Color.WHITE);
        tablePane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        tablePane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        table.setAutoResizeMode(JXTable.AUTO_RESIZE_ALL_COLUMNS);
        descriptionPane.setColumnHeaderView(new JLabel(t("config.description"), SwingUtil.getUIManagerActionIcon("information"), 10));
        SwingUtil.setText(description, t("config.no.option.selected"));
        
        reset.setIcon(SwingUtil.createActionIcon("config-reset"));
        save.setIcon(SwingUtil.createActionIcon("config-save"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        createModel();
        createCategoryModel();
        createTableModel();
        createSelectionModel();
        createCategoryLabelPanel();
        createCategoryLabel();
        createTablePane();
        createTable();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createDescriptionPane();
        createDescription();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createReset();
        createSave();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_PANE_COLUMN_HEADER_VIEW, true) {
        
            @Override
            public void applyDataBinding() {
                if (table != null) {
                    table.addPropertyChangeListener("tableHeader", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (table != null) {
                    tablePane.setColumnHeaderView(table.getTableHeader());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (table != null) {
                    table.removePropertyChangeListener("tableHeader", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESET_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().addPropertyChangeListener("modified", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getCategoryModel() != null) {
                    reset.setEnabled(getCategoryModel().isModified());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().removePropertyChangeListener("modified", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().addPropertyChangeListener("modified", this);
                }
                if (getCategoryModel() != null) {
                    getCategoryModel().addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getCategoryModel() != null) {
                    save.setEnabled(getCategoryModel().isModified() && getCategoryModel().isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().removePropertyChangeListener("modified", this);
                }
                if (getCategoryModel() != null) {
                    getCategoryModel().removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}