/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tags.swing;

import java.awt.Color;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompilerException;
import jaxx.compiler.I18nHelper;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.binding.DataBindingHelper;
import jaxx.compiler.reflect.ClassDescriptorLoader;
import jaxx.compiler.tags.TagHandler;
import jaxx.compiler.tags.swing.JTabbedPaneHandler;
import jaxx.compiler.types.TypeManager;
import jaxx.runtime.swing.TabInfo;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TabHandler
implements TagHandler {
    @Override
    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        this.compileChildrenFirstPass(tag, compiler);
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        if (!ClassDescriptorLoader.getClassDescriptor(JTabbedPane.class).isAssignableFrom(compiler.getOpenComponent().getObjectClass())) {
            compiler.reportError("tab tag may only appear within JTabbedPane tag");
            return;
        }
        JTabbedPaneHandler.CompiledTabbedPane tabs = (JTabbedPaneHandler.CompiledTabbedPane)compiler.getOpenComponent();
        String id = tag.getAttribute("id");
        if (id == null || id.length() == 0) {
            id = compiler.getAutoId(TabInfo.class.getSimpleName());
        }
        TabInfo tabInfo = new TabInfo(id);
        CompiledObject compiledTabInfo = new CompiledObject(id, ClassDescriptorLoader.getClassDescriptor(TabInfo.class), compiler);
        compiler.registerCompiledObject(compiledTabInfo);
        tabs.tabInfo = tabInfo;
        this.setAttributes(compiledTabInfo, tabs, tag, compiler);
        this.compileChildrenSecondPass(tag, compiler);
        tabs.tabInfo = null;
    }

    public static void setAttribute(CompiledObject compiledTabInfo, JTabbedPaneHandler.CompiledTabbedPane tabs, String name, String value, JAXXCompiler compiler) throws CompilerException {
        value = value.trim();
        TabInfo tabInfo = tabs.tabInfo;
        String id = tabInfo.getId();
        String binding = DataBindingHelper.processDataBindings(value);
        if (binding != null) {
            compiler.getBindingHelper().registerDataBinding(id + "." + name, binding, id + ".set" + StringUtils.capitalize((String)name) + "(" + binding + ");");
            return;
        }
        String valueCode = TypeManager.getJavaCode(value);
        if (I18nHelper.isI18nableAttribute(name, compiler)) {
            value = valueCode = I18nHelper.addI18nInvocation(id, name, valueCode, compiler);
        }
        if (!name.equals("id")) {
            if (name.equals("title")) {
                tabInfo.setTitle(value);
                compiledTabInfo.appendInitializationCode(id + ".setTitle(" + valueCode + ");");
            } else if (name.equals("toolTipText")) {
                tabInfo.setToolTipText(value);
                compiledTabInfo.appendInitializationCode(id + ".setToolTipText(" + valueCode + ");");
            } else if (name.equals("icon")) {
                Icon icon = (Icon)TypeManager.convertFromString(value, Icon.class);
                tabInfo.setIcon(icon);
                compiledTabInfo.appendInitializationCode(id + ".setIcon(" + TypeManager.getJavaCode(icon) + ");");
            } else if (name.equals("enabled")) {
                boolean enabled = (Boolean)TypeManager.convertFromString(value, Boolean.class);
                tabInfo.setEnabled(enabled);
                compiledTabInfo.appendInitializationCode(id + ".setEnabled(" + enabled + ");");
            } else if (name.equals("disabledIcon")) {
                Icon disabledIcon = (Icon)TypeManager.convertFromString(value, Icon.class);
                tabInfo.setDisabledIcon(disabledIcon);
                compiledTabInfo.appendInitializationCode(id + ".setDisabledIcon(" + TypeManager.getJavaCode(disabledIcon) + ");");
            } else if (name.equals("mnemonic")) {
                char mnemonic = ((Character)TypeManager.convertFromString(value, Character.TYPE)).charValue();
                tabInfo.setMnemonic((int)mnemonic);
                compiledTabInfo.appendInitializationCode(id + ".setMnemonic(" + mnemonic + ");");
            } else if (name.equals("displayedMnemonicIndex")) {
                int displayedMnemonicIndex = (Integer)TypeManager.convertFromString(value, Integer.TYPE);
                tabInfo.setDisplayedMnemonicIndex(displayedMnemonicIndex);
                compiledTabInfo.appendInitializationCode(id + ".setDisplayedMnemonicIndex(" + displayedMnemonicIndex + ");");
            } else if (name.equals("foreground")) {
                Color foreground = (Color)TypeManager.convertFromString(value, Color.class);
                tabInfo.setForeground(foreground);
                compiledTabInfo.appendInitializationCode(id + ".setForeground(" + TypeManager.getJavaCode(foreground) + ");");
            } else if (name.equals("background")) {
                Color background = (Color)TypeManager.convertFromString(value, Color.class);
                tabInfo.setBackground(background);
                compiledTabInfo.appendInitializationCode(id + ".setBackground(" + TypeManager.getJavaCode(background) + ");");
            } else if (name.equals("tabComponent")) {
                tabInfo.setTabComponentStr(TypeManager.getJavaCode(value));
                compiledTabInfo.appendInitializationCode(id + ".setTabComponent(" + TypeManager.getJavaCode(value) + ");");
            } else {
                compiler.reportError("The <tab> tag does not support the attribute '" + name + "'");
            }
        }
    }

    public void setAttributes(CompiledObject compiledTabInfo, JTabbedPaneHandler.CompiledTabbedPane tabs, Element tag, JAXXCompiler compiler) throws CompilerException {
        NamedNodeMap children = tag.getAttributes();
        for (int i = 0; i < children.getLength(); ++i) {
            Attr attribute = (Attr)children.item(i);
            String name = attribute.getName();
            String value = attribute.getValue();
            if (name.startsWith("xmlns") || "http://www.jaxxframework.org/internal".equals(attribute.getNamespaceURI())) continue;
            TabHandler.setAttribute(compiledTabInfo, tabs, name, value, compiler);
        }
    }

    protected void compileChildrenFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String text;
            Node node = children.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                Element child = (Element)node;
                this.compileChildTagFirstPass(child, compiler);
                continue;
            }
            if (nodeType != 3 && nodeType != 4 || (text = ((Text)node).getData().trim()).length() <= 0) continue;
            compiler.reportError("tag '" + tag.getLocalName() + "' may not contain text ('" + ((Text)node).getData().trim() + "')");
        }
    }

    protected void compileChildTagFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        compiler.compileFirstPass(tag);
    }

    protected void compileChildrenSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String text;
            Node node = children.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                Element child = (Element)node;
                this.compileChildTagSecondPass(child, compiler);
                continue;
            }
            if (nodeType != 3 && nodeType != 4 || (text = ((Text)node).getData().trim()).length() <= 0) continue;
            compiler.reportError("tag '" + tag.getLocalName() + "' may not contain text ('" + ((Text)node).getData().trim() + "')");
        }
    }

    protected void compileChildTagSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        compiler.compileSecondPass(tag);
    }
}

