/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.java;

import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class JavaElement {
    private String name;
    private int modifiers;
    public static final Comparator<JavaElement> JavaElementComparator = new Comparator<JavaElement>(){
        final Pattern NAME_PATTERN = Pattern.compile("(.+)([0-9]+)");

        @Override
        public int compare(JavaElement o1, JavaElement o2) {
            String n1 = o1.getName();
            String n2 = o2.getName();
            Matcher matcher1 = this.NAME_PATTERN.matcher(n1);
            Matcher matcher2 = this.NAME_PATTERN.matcher(n2);
            if (matcher1.matches() && matcher2.matches()) {
                String p2;
                String p1 = matcher1.group(1);
                int i = p1.compareTo(p2 = matcher1.group(2));
                if (i != 0) {
                    return i;
                }
                int i1 = Integer.valueOf(matcher1.group(2));
                int i2 = Integer.valueOf(matcher2.group(2));
                return i1 - i2;
            }
            return n1.compareTo(n2);
        }
    };

    public JavaElement(int modifiers, String name) {
        this.modifiers = modifiers;
        this.name = name;
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String className) {
        this.name = className;
    }

    public final String getModifiersText() {
        if (this.modifiers == 0) {
            return "";
        }
        return Modifier.toString(this.modifiers) + ' ';
    }
}

