/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tags.swing;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.IOException;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.UnsupportedAttributeException;
import jaxx.compiler.tags.TagHandler;
import jaxx.compiler.tags.swing.TableHandler;
import jaxx.compiler.types.TypeManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class CellHandler
implements TagHandler {
    @Override
    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        this.compileChildrenFirstPass(tag, compiler);
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        Node parent = tag.getParentNode();
        if (parent.getNodeType() != 1 || !parent.getLocalName().equals("row")) {
            compiler.reportError("cell tag may only appear within row tag");
            return;
        }
        TableHandler.CompiledTable table = (TableHandler.CompiledTable)compiler.getOpenComponent();
        table.newCell();
        GridBagConstraints c = table.getCellConstraints();
        CellHandler.setAttributes(c, tag);
        this.compileChildrenSecondPass(tag, compiler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setAttribute(GridBagConstraints c, String name, String value) throws CompilerException {
        value = value.trim();
        if (name.equals("insets")) {
            c.insets = (Insets)TypeManager.convertFromString(value, Insets.class);
            return;
        } else if (name.equals("weightx")) {
            c.weightx = Double.parseDouble(value);
            return;
        } else if (name.equals("weighty")) {
            c.weighty = Double.parseDouble(value);
            return;
        } else if (name.equals("columns")) {
            c.gridwidth = Integer.parseInt(value);
            return;
        } else if (name.equals("rows")) {
            c.gridheight = Integer.parseInt(value);
            return;
        } else if (name.equals("fill")) {
            if (value.equals("none")) {
                c.fill = 0;
                return;
            } else if (value.equals("horizontal")) {
                c.fill = 2;
                return;
            } else if (value.equals("vertical")) {
                c.fill = 3;
                return;
            } else {
                if (!value.equals("both")) throw new IllegalArgumentException("invalid value for fill attribute: '" + value + "'");
                c.fill = 1;
            }
            return;
        } else {
            if (!name.equals("anchor")) throw new UnsupportedAttributeException(name);
            if (value.equals("north")) {
                c.anchor = 11;
                return;
            } else if (value.equals("northeast")) {
                c.anchor = 12;
                return;
            } else if (value.equals("east")) {
                c.anchor = 13;
                return;
            } else if (value.equals("southeast")) {
                c.anchor = 14;
                return;
            } else if (value.equals("south")) {
                c.anchor = 15;
                return;
            } else if (value.equals("southwest")) {
                c.anchor = 16;
                return;
            } else if (value.equals("west")) {
                c.anchor = 17;
                return;
            } else if (value.equals("northwest")) {
                c.anchor = 18;
                return;
            } else {
                if (!value.equals("center")) throw new IllegalArgumentException("invalid value for anchor attribute: '" + value + "'");
                c.anchor = 10;
            }
        }
    }

    public static void setAttributes(GridBagConstraints c, Element tag) throws CompilerException {
        NamedNodeMap children = tag.getAttributes();
        for (int i = 0; i < children.getLength(); ++i) {
            Attr attribute = (Attr)children.item(i);
            String name = attribute.getName();
            String value = attribute.getValue();
            if (name.startsWith("xmlns") || "http://www.jaxxframework.org/internal".equals(attribute.getNamespaceURI())) continue;
            CellHandler.setAttribute(c, name, value);
        }
    }

    protected void compileChildrenFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String text;
            Node node = children.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                Element child = (Element)node;
                this.compileChildTagFirstPass(child, compiler);
                continue;
            }
            if (nodeType != 3 && nodeType != 4 || (text = ((Text)node).getData().trim()).length() <= 0) continue;
            compiler.reportError("tag '" + tag.getLocalName() + "' may not contain text ('" + ((Text)node).getData().trim() + "')");
        }
    }

    protected void compileChildrenSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String text;
            Node node = children.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                Element child = (Element)node;
                this.compileChildTagSecondPass(child, compiler);
                continue;
            }
            if (nodeType != 3 && nodeType != 4 || (text = ((Text)node).getData().trim()).length() <= 0) continue;
            compiler.reportError("tag '" + tag.getLocalName() + "' may not contain text ('" + ((Text)node).getData().trim() + "')");
        }
    }

    protected void compileChildTagFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        compiler.compileFirstPass(tag);
    }

    protected void compileChildTagSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        compiler.compileSecondPass(tag);
    }
}

