/*
 * #%L
 * I18n :: Maven Plugin
 * 
 * $Id: ParserJavaActionConfigMojo.java 1795 2010-11-11 10:52:30Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/i18n/tags/i18n-2.0/maven-i18n-plugin/src/main/java/org/nuiton/i18n/plugin/parser/impl/ParserJavaActionConfigMojo.java $
 * %%
 * Copyright (C) 2007 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.i18n.plugin.parser.impl;

import org.nuiton.i18n.plugin.parser.FileParser;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Un parseur java pour scanner les annotations ActionConfig
 *
 * @author tchemit <chemit@codelutin.com>
 * @goal parserJavaActionConfig
 * @phase generate-resources
 * @deprecated since 2.0, will not be replaced (was used by {@code jaxx-swing-action} project which is dead...)
 */
@Deprecated
public class ParserJavaActionConfigMojo extends ParserJavaMojo {

    protected static final Pattern MATCH_PATTERN = Pattern.compile("(name|shortDescription|longDescription|name2|shortDescription2|longDescription2)\\s*=\\s*\"([\\w|\\.]+)\"(|\\s*|\\s*,\\s*$)");

    @Override
    protected String getOutGetter() {
        return "java-action-config.getter";
    }

    @Override
    public FileParser newFileParser() {

        return new JavaFileParser(
                getLog(),
                getEncoding(),
                oldParser,
                showTouchedFiles) {

            @Override
            public void parseLine(File srcFile, String line) {
                String key = extract(line);
                if (key != null) {
                    setTouched(true);
                    registerKey(key);

                }
            }

            String extract(String i18nString) {
                Matcher matcher = MATCH_PATTERN.matcher(i18nString.trim());
                if (matcher.matches()) {
                    return matcher.group(2);
                }
                return null;
            }
        };
    }

    @Override
    protected String getKeyModifierStart() {
        return "[\\w|\\.]+\\s*=\\s*\"";
    }

    @Override
    protected String getKeyModifierEnd() {
        return "\"\\s*(\\)|,|\\+|$)";
    }
}
