/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser.impl;

import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import org.nuiton.i18n.plugin.parser.I18nSourceEntry;
import org.nuiton.i18n.plugin.parser.SourceEntry;
import org.nuiton.i18n.plugin.parser.impl.ParserXmlMojo;
import org.nuiton.io.FileUpdater;
import org.nuiton.io.MirroredFileUpdater;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ParserValidationMojo
extends ParserXmlMojo {
    final URL xworksResource = ((Object)((Object)this)).getClass().getResource("/xwork-validator-1.0.2.dtd");
    protected String defaultIncludes;
    protected File cp;
    protected String rulesValidation;
    protected File defaultBasedir;
    protected boolean useLocalResolver;

    @Override
    public String[] getDefaultIncludes() {
        return new String[]{this.defaultIncludes};
    }

    @Override
    public String[] getDefaultExcludes() {
        return I18nSourceEntry.EMPTY_STRING_ARRAY;
    }

    @Override
    public File getDefaultBasedir() {
        return this.defaultBasedir;
    }

    @Override
    public FileUpdater newFileUpdater(SourceEntry entry) {
        return new MirroredFileUpdater("", "", entry.getBasedir(), this.cp){

            public File getMirrorFile(File f) {
                String file = f.getAbsolutePath().substring(this.prefixSourceDirecotory);
                return new File(this.destinationDirectory + File.separator + file);
            }
        };
    }

    @Override
    protected String getOutGetter() {
        return "validation.getter";
    }

    @Override
    protected String getFileRules() {
        return this.rulesValidation;
    }

    @Override
    protected String getCoreFileRules() {
        return "validation.rules";
    }

    @Override
    protected ParserXmlMojo.XmlFileParser newXmlFileParser(XPath xpath, DocumentBuilder builder) {
        builder.setEntityResolver(this.getEntityResolver());
        return new ParserXmlMojo.XmlFileParser(this.getLog(), this.encoding, this.oldParser, this.showTouchedFiles, this.rules, xpath, builder){

            @Override
            public String extract(String i18nString) {
                int end;
                String s = null;
                if (!i18nString.trim().isEmpty() && (end = (s = i18nString.trim()).indexOf("##")) > 0) {
                    s = s.substring(0, end);
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)(i18nString + " = " + s));
                }
                return s;
            }
        };
    }

    protected EntityResolver getEntityResolver() {
        return new EntityResolver(){
            public static final String XWORK_PUBLIC_ID = "-//OpenSymphony Group//XWork Validator 1.0.2//EN";
            boolean useLocal;
            {
                this.useLocal = ParserValidationMojo.this.useLocalResolver;
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (ParserValidationMojo.this.getLog().isDebugEnabled()) {
                    ParserValidationMojo.this.getLog().debug((CharSequence)("publicID:" + publicId + ", systemId:" + systemId));
                }
                if (XWORK_PUBLIC_ID.equals(publicId)) {
                    if (!this.useLocal) {
                        URL uri = new URL(systemId);
                        if (ParserValidationMojo.this.verbose) {
                            ParserValidationMojo.this.getLog().info((CharSequence)("try to connect to " + uri));
                        }
                        URLConnection openConnection = uri.openConnection();
                        openConnection.setUseCaches(true);
                        openConnection.setConnectTimeout(1000);
                        try {
                            openConnection.connect();
                            return new InputSource(openConnection.getInputStream());
                        }
                        catch (SocketTimeoutException e) {
                            this.useLocal = true;
                        }
                        catch (IOException e) {
                            this.useLocal = true;
                        }
                    }
                    InputSource inputSource = new InputSource(ParserValidationMojo.this.xworksResource.openStream());
                    return inputSource;
                }
                return null;
            }
        };
    }

    @Override
    @Deprecated
    protected String getKeyModifierStart() {
        return "=\\s*[\"']";
    }

    @Override
    @Deprecated
    protected String getKeyModifierEnd() {
        return "[\"']";
    }
}

