package org.nuiton.i18n.plugin.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.nuiton.util.SourceEntry;

/**
 * Customized {@link SourceEntry} for parsers goals.
 * 
 * @author chemit
 */
public class I18nSourceEntry extends SourceEntry {

    public boolean init(AbstractI18nParser mojo) {
        if (!useForGoal(mojo.getClass().getSimpleName())) {
            // skip not for this goal
            skipMessage = "exclude for this goal.";
            return true;
        }

        String[] filesForEntry = getFilesForEntry(mojo);

        if (filesForEntry.length == 0) {
            // skip no file found
            skipMessage = "no file found.";
            return true;
        }
        setUpdater(mojo.newFileUpdater(this));

        if (mojo.isStrictMode() || updater == null) {
            // mojo strict mode or not updater, so force all files
            skipFiles = new String[0];
            this.files = filesForEntry;
            return false;
        }

        List<String> listFiles = new ArrayList<String>();
        List<String> listSkipFiles = new ArrayList<String>();

        // test if have any file
        for (String foundFile : filesForEntry) {
            File file = new File(getBasedir(), foundFile);
            if (isFileUptodate(file)) {
                listSkipFiles.add(foundFile);
            } else {
                listFiles.add(foundFile);
            }
        }
        boolean todo = !listFiles.isEmpty();
        if (!todo) {
            // skip, no file out-of -date
            skipMessage = "all files are up to date.";
            this.skipFiles = listSkipFiles.toArray(new String[listSkipFiles.size()]);
            this.files = new String[0];
            return true;
        }
        this.skipFiles = listSkipFiles.toArray(new String[listSkipFiles.size()]);
        this.files = listFiles.toArray(new String[listFiles.size()]);
        return false;
    }

    /**
     * Obtain all the relative path of files to treate for a given entry.
     *
     * @param mojo the given mojo
     * @return the list of relative path of files for the given entry
     */
    protected String[] getFilesForEntry(AbstractI18nParser mojo) {
        return getIncludedFiles(mojo.getDefaultBasedir(), mojo.getDefaultIncludes(), mojo.getDefaultExcludes());
    }
}
