/*
 * *##% Plugin maven pour i18n
 * Copyright (C) 2007 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%* */

package org.nuiton.i18n.plugin.parser.impl;

import org.nuiton.util.SourceEntry;
import org.nuiton.util.FileUpdater;

/**
 * Recuperation des chaines à traduire depuis les fichiers xml Swixat.
 *
 * @author julien
 * @goal parserSwixat
 * @phase generate-resources
 * @deprecated since 1.0.0 : swixat is dead...
 */
@Deprecated
public class ParserSwixat extends ParserXml {

    /**
     * Source entries (src+includes) .
     *
     * @parameter expression="${i18n.defaultIncludes}" default-value="**\\/*.xml"
     */
    protected String defaultIncludes;

    /**
     * Source entries (src+excludes) .
     *
     * @parameter expression="${i18n.defaultIncludes}" default-value="**\\/context.xml"
     */
    protected String defaultExcludes;

    /**
     * Regles xml.
     *
     * @parameter expression="${i18n.rulesSwixat}" default-value="swixat.rules"
     */
    protected String rulesSwixat;

    @Override
    public String[] getDefaultIncludes() {
        return new String[]{defaultIncludes};
    }

    @Override
    public String[] getDefaultExcludes() {
        return new String[]{defaultExcludes};
    }

    @Override
    public FileUpdater newFileUpdater(SourceEntry entry) {
        return null;
    }

    @Override
    protected String getKeyModifierStart() {
        return "=\\s*[\"\']";
    }

    @Override
    protected String getKeyModifierEnd() {
        return "[\"\']";
    }

    @Override
    protected String getOutGetter() {
        return "swixat.getter";
    }

    @Override
    protected String getFileRules() {
        return rulesSwixat;
    }

    @Override
    protected String getCoreFileRules() {
        return "swixat.rules";
    }

    /*
     * (non-Javadoc)
     * @see org.codelutin.i18n.plugin.extension.XmlParser#extract(java.lang.String)
     */
    @Override
    public String extract(String i18nString) {
        return i18nString;
    }
}
