/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.PlexusTestCase;
import org.junit.Assert;
import org.nuiton.plugin.PluginHelper;

public abstract class TestHelper
extends PluginHelper {
    private static final Log log = LogFactory.getLog(TestHelper.class);
    protected static boolean verbose;
    protected static File basedir;
    protected static File testBasedir;

    public static File getTestBasedir() {
        if (testBasedir == null) {
            testBasedir = TestHelper.getFile((File)TestHelper.getBasedir(), (String[])new String[]{"target", "test-classes"});
            if (log.isDebugEnabled()) {
                log.debug((Object)("testBasedir = " + testBasedir));
            }
        }
        return testBasedir;
    }

    public static File getBasedir() {
        if (basedir == null) {
            String path = PlexusTestCase.getBasedir();
            basedir = new File(path);
            if (verbose) {
                System.out.println("basedir = " + basedir.getAbsolutePath());
            }
        }
        return basedir;
    }

    public static void setBasedir(File basedir) {
        TestHelper.basedir = basedir;
    }

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean verbose) {
        TestHelper.verbose = verbose;
    }

    public static File getTestDir(Class<?> type, String prefix) {
        File f = new File(TestHelper.getBasedir(), prefix);
        String rep = type.getName();
        String[] paths = rep.split("\\.");
        File testDir = PluginHelper.getFile((File)f, (String[])paths);
        return testDir;
    }

    public static void checkExistsPattern(File file, String pattern, String encoding, boolean required) throws IOException {
        Assert.assertTrue((String)("File '" + file + "' does not exist, but should..."), (boolean)file.exists());
        String content = PluginHelper.readAsString((File)file, (String)encoding);
        TestHelper.checkPattern(file, content, pattern, required);
    }

    public static void checkPattern(File file, String content, String pattern, boolean required) throws IOException {
        String errorMessage = required ? "could not find the pattern : " : "should not have found pattern :";
        Assert.assertEquals((String)(errorMessage + pattern + " in '" + file + "'"), (Object)required, (Object)content.contains(pattern));
    }
}

