/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.guix.generator;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuiton.guix.generator.JavaArgument;
import org.nuiton.guix.generator.JavaField;
import org.nuiton.guix.generator.JavaMethod;

public class JavaFile {
    protected static final int CLASS = 0;
    protected static final int ABSTRACT_CLASS = 1;
    protected static final int INTERFACE = 2;
    protected static final String GETTER_PATTERN = "return %1$s;";
    protected static final String BOOLEAN_GETTER_PATTERN = "return %1$s !=null && %1$s;";
    protected static final String SETTER_PATTERN = "this.%2$s = newValue;";
    private int modifiers;
    private int classType;
    private String packageName;
    private String className;
    private List<String> imports = new ArrayList<String>();
    private List<JavaField> fields = new ArrayList<JavaField>();
    private List<JavaField> inheritedFields = new ArrayList<JavaField>();
    private List<JavaMethod> methods = new ArrayList<JavaMethod>();
    private List<JavaMethod> inheritedMethods = new ArrayList<JavaMethod>();
    private List<JavaFile> innerClasses = new ArrayList<JavaFile>();
    private String superClass;
    private List<String> interfaces;
    private StringBuffer rawBodyCode = new StringBuffer();
    private boolean superclassIsGuixObject = false;
    private String genericType;
    private String superGenericType;
    private String javaDoc;

    public JavaFile() {
    }

    public JavaFile(int modifiers, int classType, String packageName, String className, String superClass, String javaDoc) {
        this(modifiers, classType, packageName, className, superClass, null, javaDoc);
    }

    public JavaFile(int modifiers, int classType, String packageName, String className, String superClass, List<String> interfaces, String javaDoc) {
        this.classType = classType;
        this.packageName = packageName;
        this.modifiers = modifiers;
        this.className = className;
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.javaDoc = javaDoc;
    }

    public void addImport(String importString) {
        this.imports.add(importString);
    }

    public void addImport(Class importString) {
        this.imports.add(importString.getName());
    }

    public String[] getImports() {
        return this.imports.toArray(new String[this.imports.size()]);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(String superClass) {
        this.superClass = superClass;
    }

    public List<String> getInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = new ArrayList<String>();
        }
        return this.interfaces;
    }

    public void setInterfaces(List<String> interfaces) {
        this.interfaces = interfaces;
    }

    public void setGenericType(String genericType) {
        this.genericType = genericType;
    }

    public void addMethod(JavaMethod method) {
        this.methods.add(method);
    }

    public JavaMethod[] getMethods() {
        return this.methods.toArray(new JavaMethod[this.methods.size()]);
    }

    public JavaMethod getMethod(String methodName, JavaArgument[] args) {
        int i;
        boolean samesame;
        for (JavaMethod method : this.methods) {
            if (!method.getName().equals(methodName)) continue;
            if (method.getArguments() == null && args == null) {
                return method;
            }
            if (method.getArguments() == null || args == null || method.getArguments().length != args.length) continue;
            samesame = true;
            for (i = 0; i < args.length; ++i) {
                if (args[i].getName().equals(method.getArguments()[i].getName()) && args[i].getType().equals(method.getArguments()[i].getType())) continue;
                samesame = false;
                break;
            }
            if (!samesame) continue;
            return method;
        }
        for (JavaMethod method : this.inheritedMethods) {
            if (!method.getName().equals(methodName)) continue;
            if (method.getArguments() == null && args == null) {
                return method;
            }
            if (method.getArguments() == null || args == null || method.getArguments().length != args.length) continue;
            samesame = true;
            for (i = 0; i < args.length; ++i) {
                if (args[i].getName().equals(method.getArguments()[i].getName()) && args[i].getType().equals(method.getArguments()[i].getType())) continue;
                samesame = false;
                break;
            }
            if (!samesame) continue;
            return method;
        }
        return null;
    }

    public void addInheritedMethod(JavaMethod method) {
        this.inheritedMethods.add(method);
    }

    public JavaMethod[] getInheritedMethods() {
        return this.inheritedMethods.toArray(new JavaMethod[this.inheritedMethods.size()]);
    }

    public JavaMethod getInheritedMethod(String methodName, JavaArgument[] args) {
        for (JavaMethod method : this.inheritedMethods) {
            if (!method.getName().equals(methodName)) continue;
            if (method.getArguments() == null && args == null) {
                return method;
            }
            if (method.getArguments() == null || args == null || method.getArguments().length != args.length) continue;
            boolean samesame = true;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].getName().equals(method.getArguments()[i].getName()) && args[i].getType().equals(method.getArguments()[i].getType())) continue;
                samesame = false;
                break;
            }
            if (!samesame) continue;
            return method;
        }
        return null;
    }

    public JavaMethod[] getAllMethods() {
        ArrayList<JavaMethod> allMethods = new ArrayList<JavaMethod>();
        allMethods.addAll(this.methods);
        allMethods.addAll(this.inheritedMethods);
        return allMethods.toArray(new JavaMethod[allMethods.size()]);
    }

    public void addField(JavaField field) {
        this.addField(field, false);
    }

    public void addField(JavaField field, boolean javaBean) {
        this.addSimpleField(field);
        String id = field.getName();
        String capitalizedName = id != null && id.length() > 0 ? Character.toUpperCase(id.charAt(0)) + id.substring(1) : id;
        String content = this.classType == 2 ? null : String.format(GETTER_PATTERN, id);
        this.addMethod(new JavaMethod(1, field.getType(), "get" + capitalizedName, null, null, content, null));
        if (javaBean) {
            if (Boolean.class.getName().equals(field.getType())) {
                content = this.classType == 2 ? null : String.format(BOOLEAN_GETTER_PATTERN, id);
                this.addMethod(new JavaMethod(1, field.getType(), "is" + capitalizedName, null, null, content, null));
            }
            content = this.classType == 2 ? null : String.format(SETTER_PATTERN, field.getType(), id);
            JavaArgument arg = new JavaArgument(field.getType(), "newValue");
            this.addMethod(new JavaMethod(1, "void", "set" + capitalizedName, new JavaArgument[]{arg}, null, content, null));
        }
    }

    public void addSimpleField(JavaField field) {
        this.fields.add(field);
    }

    public void addInheritedField(JavaField field) {
        this.inheritedFields.add(field);
    }

    public JavaField[] getFields() {
        return this.fields.toArray(new JavaField[this.fields.size()]);
    }

    public JavaField getField(String fieldName) {
        for (JavaField field : this.fields) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        for (JavaField field : this.inheritedFields) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public JavaField[] getInheritedFields() {
        return this.inheritedFields.toArray(new JavaField[this.inheritedFields.size()]);
    }

    public JavaField getInheritedField(String fieldName) {
        for (JavaField field : this.inheritedFields) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public JavaField[] getAllFields() {
        ArrayList<JavaField> allFields = new ArrayList<JavaField>();
        allFields.addAll(this.fields);
        allFields.addAll(this.inheritedFields);
        return allFields.toArray(new JavaField[allFields.size()]);
    }

    public static String addIndentation(String source, String lineSeparator) {
        return JavaFile.indent(source, false, lineSeparator);
    }

    public static String setIndentation(String source, String lineSeparator) {
        return JavaFile.indent(source, true, lineSeparator);
    }

    public static String indent(String source, boolean trim, String lineSeparator) {
        if (trim) {
            source = source.trim();
        }
        char[] spaces = new char[1];
        Arrays.fill(spaces, '\t');
        StringBuffer result = new StringBuffer();
        String[] lines = source.split(System.getProperty("line.separator") + "|\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                result.append(lineSeparator);
            }
            if (lines[i].equals(lines[i].trim()) && (lines[i].trim().startsWith("}") || lines[i].trim().endsWith("}"))) {
                spaces = new char[spaces.length - 1];
                Arrays.fill(spaces, '\t');
            }
            result.append(spaces);
            result.append(trim ? lines[i].trim() : lines[i]);
            if (!lines[i].equals(lines[i].trim()) || !lines[i].trim().endsWith("{")) continue;
            spaces = new char[spaces.length + 1];
            Arrays.fill(spaces, '\t');
        }
        return result.toString();
    }

    public void addBodyCode(String bodyCode) {
        this.rawBodyCode.append(bodyCode);
    }

    public String getClassBody(String lineSeparator) {
        StringBuffer result = new StringBuffer("\t");
        if (this.classType != 2 && this.fields.size() > 0) {
            Collections.sort(this.fields);
            for (JavaField field : this.fields) {
                result.append(field.toString(lineSeparator));
            }
            result.append(lineSeparator);
        }
        if (this.rawBodyCode.length() > 0) {
            result.append("/* begin raw body code */\n");
            String s = this.rawBodyCode.toString();
            if (!s.startsWith(lineSeparator)) {
                result.append(lineSeparator);
            }
            result.append(s);
            result.append(lineSeparator);
            result.append("/* end raw body code */");
            result.append(lineSeparator).append(lineSeparator);
        }
        for (JavaFile innerClass : this.innerClasses) {
            result.append(innerClass.toString());
            result.append(lineSeparator).append(lineSeparator);
        }
        EnumMap<JavaMethod.MethodOrder, List<JavaMethod>> map = JavaMethod.getSortedMethods(this.methods);
        for (Map.Entry<JavaMethod.MethodOrder, List<JavaMethod>> entry : map.entrySet()) {
            List<JavaMethod> list = entry.getValue();
            entry.getKey().generate(result, list, lineSeparator);
            list.clear();
        }
        map.clear();
        Pattern p = Pattern.compile("\\n");
        Matcher m = p.matcher(result.toString());
        return m.replaceAll("\n\t");
    }

    public String getClassDefinition(String lineSeparator) {
        StringBuffer result = new StringBuffer();
        result.append(JavaFile.getModifiersText(this.modifiers)).append(this.classType == 2 ? "interface " : "class ").append(this.className.substring(this.className.lastIndexOf(".") + 1));
        if (this.genericType != null) {
            result.append('<').append(this.genericType).append('>');
        }
        if (this.superClass != null) {
            result.append(" extends ");
            result.append(this.superClass);
            if (this.superGenericType != null) {
                result.append('<').append(this.superGenericType).append('>');
            }
        }
        if (this.interfaces != null && !this.interfaces.isEmpty()) {
            result.append(" implements ").append(this.interfaces.get(0));
            for (int i = 1; i < this.interfaces.size(); ++i) {
                result.append(", ").append(this.interfaces.get(i));
            }
        }
        result.append(" {");
        result.append(lineSeparator);
        result.append(this.getClassBody(lineSeparator));
        result.append("}");
        return result.toString();
    }

    public static String getModifiersText(int modifiers) {
        if (modifiers == 0) {
            return "";
        }
        return Modifier.toString(modifiers) + ' ';
    }

    public String toString(String lineSeparator) {
        StringBuffer result = new StringBuffer();
        if (this.packageName != null && !this.packageName.equals("")) {
            result.append("package ").append(this.packageName).append(";");
            result.append(lineSeparator);
            result.append(lineSeparator);
        }
        if (this.imports.size() > 0) {
            for (String anImport : this.imports) {
                result.append("import ");
                result.append(anImport);
                result.append(';');
                result.append(lineSeparator);
            }
            result.append(lineSeparator);
        }
        if (this.javaDoc != null && !this.javaDoc.equals("")) {
            result.append("/**\n * ").append(this.javaDoc.replace("\n", "\n * ")).append("\n */").append(lineSeparator);
        }
        result.append(this.getClassDefinition(lineSeparator));
        return result.toString();
    }

    public void addInterface(String canonicalName) {
        if (this.interfaces == null || !this.interfaces.contains(canonicalName)) {
            this.getInterfaces().add(canonicalName);
        }
    }

    public void addInterfaces(String[] canonicalNames) {
        if (canonicalNames == null) {
            return;
        }
        for (String canonicalName : canonicalNames) {
            if (this.interfaces != null && this.interfaces.contains(canonicalName)) continue;
            this.getInterfaces().add(canonicalName);
        }
    }

    public boolean isSuperclassIsGuixObject() {
        return this.superclassIsGuixObject;
    }

    public void setSuperclassIsGuixObject(boolean superclassIsGuixObject) {
        this.superclassIsGuixObject = superclassIsGuixObject;
    }

    public void setSuperGenericType(String superGenericType) {
        this.superGenericType = superGenericType;
    }
}

