/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.guix.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.guix.generator.JavaArgument;
import org.nuiton.guix.generator.JavaFile;
import org.nuiton.guix.generator.JavaMethod;
import org.nuiton.guix.model.GuixModelObject;

public class SwingMainClassGenerator {
    private JavaFile clazz;
    private GuixModelObject gmo;
    private Log log = LogFactory.getLog(SwingMainClassGenerator.class);

    public SwingMainClassGenerator(GuixModelObject gmo) {
        this.gmo = gmo;
        this.clazz = new JavaFile(1, 0, gmo.getClassDescriptor().getPackageName(), "Main", null, null);
    }

    public void generate(File out) {
        String gmoClass = this.gmo.getClassDescriptor().toString();
        this.clazz.addImport("java.io.File");
        StringBuffer mainMethod = new StringBuffer();
        mainMethod.append("javax.swing.SwingUtilities.invokeLater(").append("new Runnable() {\n").append("public void run() {\n").append(gmoClass).append("Impl main = new ").append(gmoClass).append("Impl();\n").append("main.setVisible(true);\n}\n});");
        this.clazz.addMethod(new JavaMethod(9, "void", "main", new JavaArgument[]{new JavaArgument("String[]", "args")}, null, mainMethod.toString(), null));
        this.saveFile(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFile(File out) {
        OutputStreamWriter fw = null;
        try {
            if (!out.exists()) {
                out.createNewFile();
            }
            fw = new FileWriter(out);
            fw.write(this.clazz.toString("\n"));
            fw.close();
        }
        catch (IOException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)ex);
            }
        }
        finally {
            try {
                fw.close();
            }
            catch (IOException ex) {
                this.log.error((Object)ex);
            }
        }
    }
}

