/**
 * *##% guix-compiler-swing
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.nuiton.guix.generator;

//~--- non-JDK imports --------------------------------------------------------
import org.nuiton.guix.model.GuixModelObject;

//~--- JDK imports ------------------------------------------------------------

import java.lang.reflect.Modifier;
import java.util.Map;
import org.nuiton.guix.tags.TagManager;

/**
 * Generator of interfaces
 *
 * @author morin
 */
public class SwingInterfaceGenerator extends SwingJavaFileGenerator {

    /**
     * Constructor
     *
     * @param gmo GuixModelObject representing the class to generate
     * @param classes List of the classes to generate
     */
    public SwingInterfaceGenerator(GuixModelObject gmo, Map<String, JavaFile> classes) {
        super(gmo, classes);
        this.classes = classes;
        jf = new JavaFile(Modifier.PUBLIC,
                JavaFile.INTERFACE,
                gmo.getClassDescriptor().getPackageName(),
                gmo.getClassDescriptor().getName(),
                null, gmo.getJavadoc());
    }

    @Override
    public JavaFile generate() {
        super.addImports();
        addFields(gmo);
        jf.addMethod(new JavaMethod(Modifier.PUBLIC, "void", "initialize", null, null, null, "initialization"));
        jf.addMethod(new JavaMethod(Modifier.PUBLIC, "void", getMethodName(Method.BEFORE_CREATION), null, null, null, ""));
        jf.addMethod(new JavaMethod(Modifier.PUBLIC, "void", getMethodName(Method.BEFORE_TREE), null, null, null, ""));
        jf.addMethod(new JavaMethod(Modifier.PUBLIC, "void", getMethodName(Method.BEFORE_SETTINGS), null, null, null, ""));
        jf.addMethod(new JavaMethod(Modifier.PUBLIC, "void", getMethodName(Method.BEFORE_BINDING), null, null, null, ""));
        jf.addMethod(new JavaMethod(Modifier.PUBLIC, "void", getMethodName(Method.IN_THE_END), null, null, null, ""));

        return jf;
    }

    /**
     * Adds fields to the file to generate
     *
     * @param gmo the GuixModelObject to analyze
     */
    private void addFields(GuixModelObject gmo) {
        for (GuixModelObject child : gmo.getChildren()) {
            //if gmo represents a Guix tag
            if (child.getClassDescriptor().getPackageName() == null
                    && TagManager.getGuixClassHandler(child.getClassDescriptor().getName()) != null) {
                if(TagManager.getGuixClassHandler(child.getClassDescriptor().getName()).getClassToGenerate() != null) {
                    jf.addField(new JavaField(Modifier.PRIVATE,
                            TagManager.getGuixClassHandler(child.getClassDescriptor().getName()).getClassToGenerate().getName(),
                            child.getId(), child.getJavadoc()),
                            gmo.isJavaBean());
                }
            }
            else {
                jf.addField(new JavaField(Modifier.PRIVATE,
                        (classes != null && classes.containsKey(child.getClassDescriptor().toString())) ? child.getClassDescriptor().toString() + "Abstract" : child.getClassDescriptor().toString(),
                        child.getId(), child.getJavadoc()),
                        gmo.isJavaBean());
            }
            addFields(child);
        }
    }
}

