/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.test.generator;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.eugene.test.generator.TopiaGeneratorUtil;

public class BeanTransformer
extends ObjectModelTransformerToJava {
    public void transformFromClass(ObjectModelClass clazz) {
        if (!clazz.hasStereotype("bean") && !clazz.hasStereotype("dto")) {
            return;
        }
        ObjectModelClass resultClass = null;
        resultClass = !clazz.getOperations().isEmpty() ? this.createAbstractClass(clazz.getName(), clazz.getPackageName()) : this.createClass(clazz.getName(), clazz.getPackageName());
        this.createForDTO(resultClass, clazz);
        Iterator j = clazz.getSuperclasses().iterator();
        if (j.hasNext()) {
            ObjectModelClass p = (ObjectModelClass)j.next();
            this.setSuperClass(resultClass, p.getQualifiedName());
        }
        for (ObjectModelClassifier parentInterface : clazz.getInterfaces()) {
            this.addInterface((ObjectModelClassifier)resultClass, parentInterface.getQualifiedName());
        }
        this.createListeners(resultClass, clazz);
        boolean hasEntity = false;
        boolean hasMultipleAttribute = false;
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable()) continue;
            String attrType = attr.getType();
            String simpleType = GeneratorUtil.getSimpleName((String)attrType);
            String attrName = attr.getName();
            String attrNameCapitalized = StringUtils.capitalize((String)attrName);
            if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                boolean isEntity;
                hasMultipleAttribute = true;
                ObjectModelOperation getChild = this.addOperation((ObjectModelClassifier)resultClass, "get" + attrNameCapitalized, attrType, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(getChild, "int", "index");
                this.setOperationBody(getChild, "\n        " + simpleType + " o = getChild(" + attrName + ", index);\n" + "        return o;\n" + "    ");
                ObjectModelClass attrEntity = null;
                if (((ObjectModel)this.getModel()).hasClass(attr.getType())) {
                    attrEntity = ((ObjectModel)this.getModel()).getClass(attr.getType());
                }
                boolean bl = isEntity = attrEntity != null && attrEntity.hasStereotype("entity");
                if (isEntity) {
                    hasEntity = true;
                    ObjectModelOperation getChildEntity = this.addOperation((ObjectModelClassifier)resultClass, "get" + attrNameCapitalized, attrType, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                    this.addParameter(getChildEntity, String.class.getName(), "topiaId");
                    this.setOperationBody(getChildEntity, "\n        " + simpleType + " o = getEntity(" + attrName + ", topiaId);\n" + "        return o;\n" + "    ");
                }
                ObjectModelOperation addChild = this.addOperation((ObjectModelClassifier)resultClass, "add" + attrNameCapitalized, attrType, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(addChild, attrType, attrName);
                this.setOperationBody(addChild, "\n        get" + attrNameCapitalized + "().add(" + attrName + ");\n" + "        firePropertyChange(\"" + attrName + "\", null, " + attrName + ");\n" + "        return " + attrName + ";\n" + "    ");
                ObjectModelOperation removeChild = this.addOperation((ObjectModelClassifier)resultClass, "remove" + attrNameCapitalized, "boolean", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(removeChild, attrType, attrName);
                this.setOperationBody(removeChild, "\n        boolean  removed = get" + attrNameCapitalized + "().remove(" + attrName + ");\n" + "        if (removed) {\n" + "            firePropertyChange(\"" + attrName + "\", " + attrName + ", null);\n" + "        }\n" + "        return removed;\n" + "    ");
                attrType = attr.isOrdered() ? List.class.getName() + "<" + attrType + ">" : Collection.class.getName() + "<" + attrType + ">";
                simpleType = GeneratorUtil.getSimpleName((String)attrType);
            }
            if (attr.hasAssociationClass()) {
                String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                attrName = GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
                attrType = attr.getAssociationClass().getName();
            }
            String visibility = attr.getVisibility();
            this.addAttribute((ObjectModelClassifier)resultClass, attrName, attrType, "", new ObjectModelModifier[]{ObjectModelModifier.toValue((String)visibility)});
            ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)resultClass, "get" + attrNameCapitalized, attrType, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
            this.setOperationBody(getter, "\n        return this." + attrName + ";\n" + "    ");
            ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)resultClass, "set" + attrNameCapitalized, "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
            this.addParameter(setter, attrType, "newValue");
            this.setOperationBody(setter, "\n        " + simpleType + " oldValue = get" + attrNameCapitalized + "();\n" + "        this." + attrName + " = newValue;\n" + "        firePropertyChange(\"" + attrName + "\", oldValue, newValue);\n" + "    ");
        }
        if (hasMultipleAttribute) {
            ObjectModelOperation getChild = this.addOperation((ObjectModelClassifier)resultClass, "getChild", "<T> T", new ObjectModelModifier[]{ObjectModelModifier.PROTECTED});
            this.addParameter(getChild, "java.util.Collection<T>", "childs");
            this.addParameter(getChild, "int", "index");
            this.setOperationBody(getChild, "\n        if (childs != null) {\n            int i = 0;\n            for (T o : childs) {\n                if (index == i) {\n                    return o;\n                }\n                i++;\n            }\n        }\n        return null;\n    ");
        }
        if (hasEntity) {
            ObjectModelOperation getEntity = this.addOperation((ObjectModelClassifier)resultClass, "getEntity", "<T extends org.nuiton.topia.persistence.TopiaEntity> T", new ObjectModelModifier[]{ObjectModelModifier.PROTECTED});
            this.addParameter(getEntity, "java.util.Collection<T>", "childs");
            this.addParameter(getEntity, "java.lang.String", "topiaId");
            this.setOperationBody(getEntity, "\n        if (childs != null) {\n            for (T o : childs) {\n                if (topiaId.equals(o.getTopiaId())) {\n                    return o;\n                }\n            }\n        }\n        return null;\n    ");
        }
        for (ObjectModelOperation op : clazz.getOperations()) {
            String visibility = op.getVisibility();
            ObjectModelOperation resultOperation = this.addOperation((ObjectModelClassifier)resultClass, op.getName(), op.getReturnType(), new ObjectModelModifier[]{ObjectModelModifier.toValue((String)visibility), ObjectModelModifier.ABSTRACT});
            for (ObjectModelParameter param : op.getParameters()) {
                this.addParameter(resultOperation, param.getType(), param.getName());
            }
            for (String exception : op.getExceptions()) {
                this.addException(resultOperation, exception);
            }
        }
    }

    private void createForDTO(ObjectModelClass resultClass, ObjectModelClass inputClass) {
        String svUID;
        if (inputClass.hasStereotype("dto")) {
            this.addInterface((ObjectModelClassifier)resultClass, "java.io.Serializable");
        }
        if ((svUID = TopiaGeneratorUtil.findTagValue("dto-serialVersionUID", (ObjectModelElement)inputClass, this.getModel())) != null) {
            this.addConstant((ObjectModelClassifier)resultClass, "serialVersionUID", "long", svUID, ObjectModelModifier.PUBLIC);
        }
    }

    protected void createListeners(ObjectModelClass resultClass, ObjectModelClass inputClass) {
        this.addAttribute((ObjectModelClassifier)resultClass, "pcs", "java.beans.PropertyChangeSupport", "", new ObjectModelModifier[]{ObjectModelModifier.PROTECTED, ObjectModelModifier.FINAL});
        ObjectModelOperation constructor = this.addConstructor(resultClass, ObjectModelModifier.PUBLIC);
        this.setOperationBody(constructor, "\n        pcs = new PropertyChangeSupport(this);\n    ");
        String propType = "java.beans.PropertyChangeListener";
        String strType = String.class.getName();
        String objectType = Object.class.getName();
        ObjectModelOperation addPropertyChangeListener = this.addOperation((ObjectModelClassifier)resultClass, "addPropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addParameter(addPropertyChangeListener, propType, "listener");
        this.setOperationBody(addPropertyChangeListener, "\n        pcs.addPropertyChangeListener(listener);\n    ");
        ObjectModelOperation addPropertyChangeListenerPlus = this.addOperation((ObjectModelClassifier)resultClass, "addPropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addParameter(addPropertyChangeListenerPlus, strType, "propertyName");
        this.addParameter(addPropertyChangeListenerPlus, propType, "listener");
        this.setOperationBody(addPropertyChangeListenerPlus, "\n        pcs.addPropertyChangeListener(propertyName, listener);\n    ");
        ObjectModelOperation removePropertyChangeListener = this.addOperation((ObjectModelClassifier)resultClass, "removePropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addParameter(removePropertyChangeListener, propType, "listener");
        this.setOperationBody(removePropertyChangeListener, "\n        pcs.removePropertyChangeListener(listener);\n    ");
        ObjectModelOperation removePropertyChangeListenerPlus = this.addOperation((ObjectModelClassifier)resultClass, "removePropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addParameter(removePropertyChangeListenerPlus, strType, "propertyName");
        this.addParameter(removePropertyChangeListenerPlus, propType, "listener");
        this.setOperationBody(removePropertyChangeListenerPlus, "\n        pcs.removePropertyChangeListener(propertyName, listener);\n    ");
        ObjectModelOperation firePropertyChange = this.addOperation((ObjectModelClassifier)resultClass, "firePropertyChange", "void", new ObjectModelModifier[]{ObjectModelModifier.PROTECTED});
        this.addParameter(firePropertyChange, strType, "propertyName");
        this.addParameter(firePropertyChange, objectType, "oldValue");
        this.addParameter(firePropertyChange, objectType, "newValue");
        this.setOperationBody(firePropertyChange, "\n        pcs.firePropertyChange(propertyName, oldValue, newValue);\n    ");
    }
}

