/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import org.neo4j.collection.primitive.hopscotch.Table;
import org.neo4j.collection.primitive.hopscotch.UnsafeTable;

public class LongKeyLongValueUnsafeTable
extends UnsafeTable<long[]> {
    public LongKeyLongValueUnsafeTable(int capacity) {
        super(capacity, 16, new long[1]);
    }

    @Override
    protected long internalKey(long keyAddress) {
        return LongKeyLongValueUnsafeTable.alignmentSafeGetLongAsTwoInts(keyAddress);
    }

    @Override
    protected void internalPut(long keyAddress, long key, long[] value) {
        LongKeyLongValueUnsafeTable.alignmentSafePutLongAsTwoInts(keyAddress, key);
        LongKeyLongValueUnsafeTable.alignmentSafePutLongAsTwoInts(keyAddress + 8L, value[0]);
    }

    @Override
    protected long[] internalRemove(long keyAddress) {
        ((long[])this.valueMarker)[0] = LongKeyLongValueUnsafeTable.alignmentSafeGetLongAsTwoInts(keyAddress + 8L);
        LongKeyLongValueUnsafeTable.alignmentSafePutLongAsTwoInts(keyAddress, -1L);
        return (long[])this.valueMarker;
    }

    @Override
    public long[] putValue(int index, long[] value) {
        long valueAddress = this.valueAddress(index);
        long oldValue = LongKeyLongValueUnsafeTable.alignmentSafeGetLongAsTwoInts(valueAddress);
        LongKeyLongValueUnsafeTable.alignmentSafePutLongAsTwoInts(valueAddress, value[0]);
        return this.pack(oldValue);
    }

    private long[] pack(long value) {
        ((long[])this.valueMarker)[0] = value;
        return (long[])this.valueMarker;
    }

    private long valueAddress(int index) {
        return this.keyAddress(index) + 8L;
    }

    @Override
    public long[] value(int index) {
        long value = LongKeyLongValueUnsafeTable.alignmentSafeGetLongAsTwoInts(this.valueAddress(index));
        return this.pack(value);
    }

    @Override
    protected Table<long[]> newInstance(int newCapacity) {
        return new LongKeyLongValueUnsafeTable(newCapacity);
    }
}

