/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.legacy.consistency.checking.labelscan;

import org.neo4j.kernel.api.direct.NodeLabelRange;
import org.neo4j.legacy.consistency.checking.CheckerEngine;
import org.neo4j.legacy.consistency.checking.RecordCheck;
import org.neo4j.legacy.consistency.checking.full.NodeInUseWithCorrectLabelsCheck;
import org.neo4j.legacy.consistency.report.ConsistencyReport;
import org.neo4j.legacy.consistency.store.DiffRecordAccess;
import org.neo4j.legacy.consistency.store.RecordAccess;
import org.neo4j.legacy.consistency.store.synthetic.LabelScanDocument;

public class LabelScanCheck
implements RecordCheck<LabelScanDocument, ConsistencyReport.LabelScanConsistencyReport> {
    @Override
    public void check(LabelScanDocument record, CheckerEngine<LabelScanDocument, ConsistencyReport.LabelScanConsistencyReport> engine, RecordAccess records) {
        NodeLabelRange range = record.getNodeLabelRange();
        for (long nodeId : range.nodes()) {
            engine.comparativeCheck(records.node(nodeId), new NodeInUseWithCorrectLabelsCheck(record.getNodeLabelRange().labels(nodeId)));
        }
    }

    @Override
    public void checkChange(LabelScanDocument oldRecord, LabelScanDocument newRecord, CheckerEngine<LabelScanDocument, ConsistencyReport.LabelScanConsistencyReport> engine, DiffRecordAccess records) {
        this.check(newRecord, engine, (RecordAccess)records);
    }
}

