/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleScriptContext
implements ScriptContext {
    private static final Integer[] SCOPES = new Integer[]{100, 200};
    protected Bindings globalScope;
    protected Bindings engineScope = new SimpleBindings();
    protected Writer writer;
    protected Writer errorWriter;
    protected Reader reader = new InputStreamReader(System.in);

    public SimpleScriptContext() {
        this.writer = new PrintWriter(System.out, true);
        this.errorWriter = new PrintWriter(System.err, true);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        switch (scope) {
            case 100: {
                if (bindings == null) {
                    throw new NullPointerException("Bindings for ENGINE scope is null");
                }
                this.engineScope = bindings;
                break;
            }
            case 200: {
                this.globalScope = bindings;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invaild scope");
            }
        }
    }

    @Override
    public Bindings getBindings(int scope) {
        switch (scope) {
            case 100: {
                return this.engineScope;
            }
            case 200: {
                return this.globalScope;
            }
        }
        throw new IllegalArgumentException("Invaild scope");
    }

    @Override
    public void setAttribute(String name, Object value, int scope) {
        Bindings bindings;
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        switch (scope) {
            case 100: {
                bindings = this.engineScope;
                break;
            }
            case 200: {
                bindings = this.globalScope;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invaild scope");
            }
        }
        if (bindings != null) {
            bindings.put(name, value);
        }
    }

    @Override
    public Object getAttribute(String name, int scope) {
        Bindings bindings;
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        switch (scope) {
            case 100: {
                bindings = this.engineScope;
                break;
            }
            case 200: {
                bindings = this.globalScope;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invaild scope");
            }
        }
        return bindings != null ? bindings.get(name) : null;
    }

    @Override
    public Object removeAttribute(String name, int scope) {
        Bindings bindings;
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        switch (scope) {
            case 100: {
                bindings = this.engineScope;
                break;
            }
            case 200: {
                bindings = this.globalScope;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope");
            }
        }
        return bindings != null ? bindings.remove(name) : null;
    }

    @Override
    public Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (this.engineScope != null && this.engineScope.containsKey(name)) {
            return this.engineScope.get(name);
        }
        if (this.globalScope != null && this.globalScope.containsKey(name)) {
            return this.globalScope.get(name);
        }
        return null;
    }

    @Override
    public int getAttributesScope(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        for (int scope : this.getScopes()) {
            if (this.getBindings(scope) == null || !this.getBindings(scope).containsKey(name)) continue;
            return scope;
        }
        return -1;
    }

    @Override
    public List<Integer> getScopes() {
        return Arrays.asList(SCOPES);
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public Writer getErrorWriter() {
        return this.errorWriter;
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void setErrorWriter(Writer writer) {
        this.errorWriter = writer;
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }
}

