/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc;

import java.util.StringTokenizer;
import net.sf.log4jdbc.ConnectionSpy;
import net.sf.log4jdbc.DriverSpy;
import net.sf.log4jdbc.ResultSetCollector;
import net.sf.log4jdbc.ResultSetCollectorPrinter;
import net.sf.log4jdbc.Spy;
import net.sf.log4jdbc.SpyLogDelegator;
import net.sf.log4jdbc.Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jSpyLogDelegator
implements SpyLogDelegator {
    private final Logger jdbcLogger = LoggerFactory.getLogger((String)"jdbc.audit");
    private final Logger resultSetLogger = LoggerFactory.getLogger((String)"jdbc.resultset");
    private final Logger resultSetTableLogger = LoggerFactory.getLogger((String)"jdbc.resultsettable");
    private final Logger sqlOnlyLogger = LoggerFactory.getLogger((String)"jdbc.sqlonly");
    private final Logger sqlTimingLogger = LoggerFactory.getLogger((String)"jdbc.sqltiming");
    private final Logger connectionLogger = LoggerFactory.getLogger((String)"jdbc.connection");
    private final Logger debugLogger = LoggerFactory.getLogger((String)"log4jdbc.debug");
    private static String nl = System.getProperty("line.separator");

    public Logger getSqlOnlyLogger() {
        return this.sqlOnlyLogger;
    }

    @Override
    public boolean isJdbcLoggingEnabled() {
        return this.jdbcLogger.isErrorEnabled() || this.resultSetLogger.isErrorEnabled() || this.sqlOnlyLogger.isErrorEnabled() || this.sqlTimingLogger.isErrorEnabled() || this.connectionLogger.isErrorEnabled() || this.resultSetTableLogger.isErrorEnabled();
    }

    @Override
    public void exceptionOccured(Spy spy, String methodCall, Exception e, String sql, long execTime) {
        String classType = spy.getClassType();
        Integer spyNo = spy.getConnectionNumber();
        String header = spyNo + ". " + classType + "." + methodCall;
        if (sql == null) {
            this.jdbcLogger.error(header, (Throwable)e);
            this.sqlOnlyLogger.error(header, (Throwable)e);
            this.sqlTimingLogger.error(header, (Throwable)e);
        } else {
            this.jdbcLogger.error(header + " " + sql, (Throwable)e);
            if (this.sqlOnlyLogger.isDebugEnabled()) {
                this.sqlOnlyLogger.error(Slf4jSpyLogDelegator.getDebugInfo() + nl + spyNo + ". " + sql, (Throwable)e);
            } else {
                this.sqlOnlyLogger.error(header + " " + sql, (Throwable)e);
            }
            if (this.sqlTimingLogger.isDebugEnabled()) {
                this.sqlTimingLogger.error(Slf4jSpyLogDelegator.getDebugInfo() + nl + spyNo + ". " + sql + " {FAILED after " + execTime + " msec}", (Throwable)e);
            } else {
                this.sqlTimingLogger.error(header + " FAILED! " + sql + " {FAILED after " + execTime + " msec}", (Throwable)e);
            }
        }
    }

    @Override
    public void methodReturned(Spy spy, String methodCall, Object returnMsg, Object object, Object ... methodParams) {
        Logger logger;
        String classType = spy.getClassType();
        Logger logger2 = logger = "ResultSet".equals(classType) ? this.resultSetLogger : this.jdbcLogger;
        if (logger.isInfoEnabled()) {
            String header = spy.getConnectionNumber() + ". " + classType + "." + methodCall + " returned " + returnMsg;
            if (logger.isDebugEnabled()) {
                logger.debug(header + " " + Slf4jSpyLogDelegator.getDebugInfo());
            } else {
                logger.info(header);
            }
        }
    }

    @Override
    public void constructorReturned(Spy spy, String constructionInfo) {
    }

    private boolean shouldSqlBeLogged(String sql) {
        if (sql == null) {
            return false;
        }
        if ((sql = sql.trim()).length() < 6) {
            return false;
        }
        sql = sql.substring(0, 6).toLowerCase();
        return DriverSpy.DumpSqlSelect && "select".equals(sql) || DriverSpy.DumpSqlInsert && "insert".equals(sql) || DriverSpy.DumpSqlUpdate && "update".equals(sql) || DriverSpy.DumpSqlDelete && "delete".equals(sql) || DriverSpy.DumpSqlCreate && "create".equals(sql);
    }

    @Override
    public String sqlOccured(Spy spy, String methodCall, String sql) {
        if (!DriverSpy.DumpSqlFilteringOn || this.shouldSqlBeLogged(sql)) {
            sql = this.processSql(sql);
            if (this.sqlOnlyLogger.isDebugEnabled()) {
                this.sqlOnlyLogger.debug(Slf4jSpyLogDelegator.getDebugInfo() + nl + spy.getConnectionNumber() + ". " + sql);
            } else if (this.sqlOnlyLogger.isInfoEnabled()) {
                this.sqlOnlyLogger.info(sql);
            }
            return sql;
        }
        return "";
    }

    @Override
    public String sqlOccured(Spy spy, String methodCall, String[] sqls) {
        String sql;
        StringBuffer batchReport = new StringBuffer("batching " + sqls.length + " statements:");
        int fieldSize = ("" + sqls.length).length();
        for (int i = 0; i < sqls.length; ++i) {
            sql = sqls[i];
            batchReport.append("\n");
            batchReport.append(Utilities.rightJustify(fieldSize, "" + i));
            batchReport.append(":  ");
            batchReport.append(sql);
        }
        sql = batchReport.toString();
        this.sqlOccured(spy, methodCall, sql);
        return sql;
    }

    private String processSql(String sql) {
        if (sql == null) {
            return null;
        }
        if (DriverSpy.TrimSql) {
            sql = sql.trim();
        }
        StringBuffer output = new StringBuffer();
        if (DriverSpy.DumpSqlMaxLineLength <= 0) {
            output.append(sql);
        } else {
            StringTokenizer st = new StringTokenizer(sql);
            int linelength = 0;
            while (st.hasMoreElements()) {
                String token = (String)st.nextElement();
                output.append(token);
                linelength += token.length();
                output.append(" ");
                if (++linelength <= DriverSpy.DumpSqlMaxLineLength) continue;
                output.append("\n");
                linelength = 0;
            }
        }
        if (DriverSpy.DumpSqlAddSemicolon) {
            output.append(";");
        }
        return output.toString();
    }

    @Override
    public void sqlTimingOccured(Spy spy, long execTime, String methodCall, String sql) {
        if (this.sqlTimingLogger.isErrorEnabled() && (!DriverSpy.DumpSqlFilteringOn || this.shouldSqlBeLogged(sql))) {
            if (DriverSpy.SqlTimingErrorThresholdEnabled && execTime >= DriverSpy.SqlTimingErrorThresholdMsec) {
                this.sqlTimingLogger.error(this.buildSqlTimingDump(spy, execTime, methodCall, sql, true));
            } else if (this.sqlTimingLogger.isWarnEnabled()) {
                if (DriverSpy.SqlTimingWarnThresholdEnabled && execTime >= DriverSpy.SqlTimingWarnThresholdMsec) {
                    this.sqlTimingLogger.warn(this.buildSqlTimingDump(spy, execTime, methodCall, sql, true));
                } else if (this.sqlTimingLogger.isDebugEnabled()) {
                    this.sqlTimingLogger.debug(this.buildSqlTimingDump(spy, execTime, methodCall, sql, true));
                } else if (this.sqlTimingLogger.isInfoEnabled()) {
                    this.sqlTimingLogger.info(this.buildSqlTimingDump(spy, execTime, methodCall, sql, false));
                }
            }
        }
    }

    private String buildSqlTimingDump(Spy spy, long execTime, String methodCall, String sql, boolean debugInfo) {
        StringBuffer out = new StringBuffer();
        if (debugInfo) {
            out.append(Slf4jSpyLogDelegator.getDebugInfo());
            out.append(nl);
            out.append(spy.getConnectionNumber());
            out.append(". ");
        }
        sql = this.processSql(sql);
        out.append(sql);
        out.append(" {executed in ");
        out.append(execTime);
        out.append(" msec}");
        return out.toString();
    }

    private static String getDebugInfo() {
        Throwable t = new Throwable();
        t.fillInStackTrace();
        StackTraceElement[] stackTrace = t.getStackTrace();
        if (stackTrace != null) {
            StringBuffer dump = new StringBuffer();
            if (DriverSpy.DumpFullDebugStackTrace) {
                boolean first = true;
                for (int i = 0; i < stackTrace.length; ++i) {
                    String className = stackTrace[i].getClassName();
                    if (className.startsWith("net.sf.log4jdbc")) continue;
                    if (first) {
                        first = false;
                    } else {
                        dump.append("  ");
                    }
                    dump.append("at ");
                    dump.append(stackTrace[i]);
                    dump.append(nl);
                }
            } else {
                int j;
                dump.append(" ");
                int firstLog4jdbcCall = 0;
                int lastApplicationCall = 0;
                for (int i = 0; i < stackTrace.length; ++i) {
                    String className = stackTrace[i].getClassName();
                    if (className.startsWith("net.sf.log4jdbc")) {
                        firstLog4jdbcCall = i;
                        continue;
                    }
                    if (!DriverSpy.TraceFromApplication || !className.startsWith(DriverSpy.DebugStackPrefix)) continue;
                    lastApplicationCall = i;
                    break;
                }
                if ((j = lastApplicationCall) == 0) {
                    j = 1 + firstLog4jdbcCall;
                }
                dump.append(stackTrace[j].getClassName()).append(".").append(stackTrace[j].getMethodName()).append("(").append(stackTrace[j].getFileName()).append(":").append(stackTrace[j].getLineNumber()).append(")");
            }
            return dump.toString();
        }
        return null;
    }

    @Override
    public void debug(String msg) {
        this.debugLogger.debug(msg);
    }

    @Override
    public void connectionOpened(Spy spy) {
        if (this.connectionLogger.isDebugEnabled()) {
            this.connectionLogger.info(spy.getConnectionNumber() + ". Connection opened " + Slf4jSpyLogDelegator.getDebugInfo());
            this.connectionLogger.debug(ConnectionSpy.getOpenConnectionsDump());
        } else {
            this.connectionLogger.info(spy.getConnectionNumber() + ". Connection opened");
        }
    }

    @Override
    public void connectionClosed(Spy spy) {
        if (this.connectionLogger.isDebugEnabled()) {
            this.connectionLogger.info(spy.getConnectionNumber() + ". Connection closed " + Slf4jSpyLogDelegator.getDebugInfo());
            this.connectionLogger.debug(ConnectionSpy.getOpenConnectionsDump());
        } else {
            this.connectionLogger.info(spy.getConnectionNumber() + ". Connection closed");
        }
    }

    @Override
    public boolean isResultSetCollectionEnabled() {
        return this.resultSetTableLogger.isInfoEnabled();
    }

    @Override
    public boolean isResultSetCollectionEnabledWithUnreadValueFillIn() {
        return this.resultSetTableLogger.isDebugEnabled();
    }

    @Override
    public void resultSetCollected(ResultSetCollector resultSetCollector) {
        new ResultSetCollectorPrinter(this.resultSetTableLogger).printResultSet(resultSetCollector);
    }
}

