/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Optional;

public enum OfferUriType {
    URI("uri"),
    QR_CODE("qr-code");

    private final String value;

    private OfferUriType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static OfferUriType fromString(String value) {
        return Optional.ofNullable(value).map(v -> {
            if (v.equals(URI.getValue())) {
                return URI;
            }
            if (v.equals(QR_CODE.getValue())) {
                return QR_CODE;
            }
            return null;
        }).orElseThrow(() -> new IllegalArgumentException(String.format("%s is not a supported OfferUriType.", value)));
    }
}

