/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.CompositeTypeCapabilities;
import kotlin.reflect.jvm.internal.impl.types.CustomTypeVariable;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SingletonTypeCapabilities;
import kotlin.reflect.jvm.internal.impl.types.Specificity;
import kotlin.reflect.jvm.internal.impl.types.SubtypingRepresentatives;
import kotlin.reflect.jvm.internal.impl.types.TypeCapabilities;
import kotlin.reflect.jvm.internal.impl.types.TypeCapability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeCapabilitiesKt {
    @NotNull
    public static final <T extends TypeCapability> TypeCapabilities addCapability(@NotNull TypeCapabilities $receiver, @NotNull Class<T> clazz, @NotNull T typeCapability) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull(typeCapability, (String)"typeCapability");
        if ($receiver.getCapability(clazz) == typeCapability) {
            return $receiver;
        }
        SingletonTypeCapabilities newCapabilities = new SingletonTypeCapabilities(clazz, typeCapability);
        if ($receiver == TypeCapabilities.NONE.INSTANCE) {
            return newCapabilities;
        }
        return new CompositeTypeCapabilities($receiver, newCapabilities);
    }

    private static final <T extends TypeCapability> T getCapability(@NotNull KotlinType $receiver) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)$receiver.getCapability(TypeCapability.class);
    }

    @NotNull
    public static final Specificity.Relation getSpecificityRelationTo(@NotNull KotlinType $receiver, @NotNull KotlinType otherType) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)otherType, (String)"otherType");
        Object object = $receiver.getCapability(Specificity.class);
        if (object == null || (object = object.getSpecificityRelationTo(otherType)) == null) {
            object = Specificity.Relation.DONT_KNOW;
        }
        return object;
    }

    public static final boolean isCustomTypeVariable(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        CustomTypeVariable customTypeVariable = $receiver.getCapability(CustomTypeVariable.class);
        return customTypeVariable != null ? customTypeVariable.isTypeVariable() : false;
    }

    @Nullable
    public static final CustomTypeVariable getCustomTypeVariable(@NotNull KotlinType $receiver) {
        CustomTypeVariable customTypeVariable;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        CustomTypeVariable customTypeVariable2 = $receiver.getCapability(CustomTypeVariable.class);
        if (customTypeVariable2 != null) {
            CustomTypeVariable customTypeVariable3 = customTypeVariable2;
            CustomTypeVariable it = customTypeVariable3;
            customTypeVariable = it.isTypeVariable() ? it : (CustomTypeVariable)null;
        } else {
            customTypeVariable = null;
        }
        return customTypeVariable;
    }

    @NotNull
    public static final KotlinType getSubtypeRepresentative(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object = $receiver.getCapability(SubtypingRepresentatives.class);
        if (object == null || (object = object.getSubTypeRepresentative()) == null) {
            object = $receiver;
        }
        return object;
    }

    @NotNull
    public static final KotlinType getSupertypeRepresentative(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object = $receiver.getCapability(SubtypingRepresentatives.class);
        if (object == null || (object = object.getSuperTypeRepresentative()) == null) {
            object = $receiver;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean sameTypeConstructors(@NotNull KotlinType first, @NotNull KotlinType second) {
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        Intrinsics.checkParameterIsNotNull((Object)second, (String)"second");
        Class<SubtypingRepresentatives> typeRangeCapability = SubtypingRepresentatives.class;
        SubtypingRepresentatives subtypingRepresentatives = first.getCapability(typeRangeCapability);
        if (subtypingRepresentatives != null ? subtypingRepresentatives.sameTypeConstructor(second) : false) return true;
        SubtypingRepresentatives subtypingRepresentatives2 = second.getCapability(typeRangeCapability);
        if (subtypingRepresentatives2 == null) return false;
        boolean bl = subtypingRepresentatives2.sameTypeConstructor(first);
        if (!bl) return false;
        return true;
    }
}

