/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/SealedInheritorInSameModuleChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class SealedInheritorInSameModuleChecker
implements DeclarationChecker {
    @NotNull
    public static final SealedInheritorInSameModuleChecker INSTANCE = new SealedInheritorInSameModuleChecker();

    private SealedInheritorInSameModuleChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor2 instanceof ClassDescriptor) || !(declaration2 instanceof KtClassOrObject)) {
            return;
        }
        ModuleDescriptor currentModule = DescriptorUtilsKt.getModule(descriptor2);
        for (KtSuperTypeListEntry superTypeListEntry : ((KtClassOrObject)declaration2).getSuperTypeListEntries()) {
            Object superClass2;
            Object superType;
            KtTypeReference ktTypeReference;
            Object object = superTypeListEntry.getTypeReference();
            if (object == null) continue;
            KtTypeReference typeReference = ktTypeReference = object;
            Object object2 = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context.trace.bindingContext");
            Object object3 = BindingContextUtilsKt.getAbbreviatedTypeOrType(typeReference, (BindingContext)object2);
            object = object3 == null ? null : ((KotlinType)object3).unwrap();
            if (object == null || (object2 = ((KotlinType)(superType = object)).getConstructor().getDeclarationDescriptor()) == null || !DescriptorUtilKt.isSealed((DeclarationDescriptor)(superClass2 = (object3 = object2))) || Intrinsics.areEqual((Object)DescriptorUtilsKt.getModule((DeclarationDescriptor)superClass2), (Object)currentModule)) continue;
            context2.getTrace().report(Errors.SEALED_INHERITOR_IN_DIFFERENT_MODULE.on((KtTypeReference)((PsiElement)typeReference)));
        }
    }
}

