/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler.xml.processes;

import org.drools.core.process.core.Work;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.compiler.xml.processes.WorkItemNodeHandler;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class HumanTaskNodeHandler
extends WorkItemNodeHandler {
    @Override
    public void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        HumanTaskNode humanTaskNode = (HumanTaskNode)node;
        String swimlane = element.getAttribute("swimlane");
        if (swimlane != null && !"".equals(swimlane)) {
            humanTaskNode.setSwimlane(swimlane);
        }
    }

    @Override
    protected Node createNode() {
        return new HumanTaskNode();
    }

    @Override
    public Class<?> generateNodeFor() {
        return HumanTaskNode.class;
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        WorkItemNode workItemNode = (WorkItemNode)node;
        this.writeNode("humanTask", (Node)workItemNode, xmlDump, includeMeta);
        this.visitParameters(workItemNode, xmlDump);
        xmlDump.append(">" + EOL);
        if (includeMeta) {
            this.writeMetaData((Node)workItemNode, xmlDump);
        }
        Work work = workItemNode.getWork();
        this.visitWork(work, xmlDump, includeMeta);
        this.visitInMappings(workItemNode.getInMappings(), xmlDump);
        this.visitOutMappings(workItemNode.getOutMappings(), xmlDump);
        for (String eventType : workItemNode.getActionTypes()) {
            this.writeActions(eventType, workItemNode.getActions(eventType), xmlDump);
        }
        this.writeTimers(workItemNode.getTimers(), xmlDump);
        this.endNode("humanTask", xmlDump);
    }

    @Override
    protected void visitParameters(WorkItemNode workItemNode, StringBuilder xmlDump) {
        super.visitParameters(workItemNode, xmlDump);
        HumanTaskNode humanTaskNode = (HumanTaskNode)workItemNode;
        String swimlane = humanTaskNode.getSwimlane();
        if (swimlane != null) {
            xmlDump.append("swimlane=\"" + swimlane + "\" ");
        }
    }
}

