/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.xnio.Buffers;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.Options;
import org.xnio.XnioExecutor;
import org.xnio.XnioWorker;
import org.xnio.channels.MulticastMessageChannel;
import org.xnio.channels.SocketAddressBuffer;
import org.xnio.channels.UnsupportedOptionException;
import org.xnio.nio.NioSetter;
import org.xnio.nio.WorkerThread;

class BioDatagramUdpChannel
implements MulticastMessageChannel {
    private static final Logger log = Logger.getLogger((String)"org.xnio.nio.udp.bio-server.channel");
    private final DatagramSocket datagramSocket;
    private final DatagramPacket receivePacket;
    private final ByteBuffer receiveBuffer;
    private final DatagramPacket sendPacket;
    private final ByteBuffer sendBuffer;
    private final ReaderTask readerTask = new ReaderTask();
    private final WriterTask writerTask = new WriterTask();
    private final ReadHandlerTask readHandlerTask = new ReadHandlerTask();
    private final WriteHandlerTask writeHandlerTask = new WriteHandlerTask();
    private final NioSetter<BioDatagramUdpChannel> readSetter = new NioSetter();
    private final NioSetter<BioDatagramUdpChannel> writeSetter = new NioSetter();
    private final NioSetter<BioDatagramUdpChannel> closeSetter = new NioSetter();
    private final WorkerThread readThread;
    private final WorkerThread writeThread;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private boolean enableRead;
    private boolean enableWrite;
    private boolean readable;
    private boolean writable;
    private IOException readException;
    private final AtomicBoolean closeCalled = new AtomicBoolean(false);
    private final XnioWorker worker;
    private static final Set<Option<?>> OPTIONS = Option.setBuilder().add(Options.BROADCAST).add(Options.IP_TRAFFIC_CLASS).create();

    BioDatagramUdpChannel(XnioWorker worker, int sendBufSize, int recvBufSize, DatagramSocket datagramSocket, WorkerThread readThread, WorkerThread writeThread) {
        this.datagramSocket = datagramSocket;
        if (sendBufSize == -1) {
            sendBufSize = 4096;
        } else if (sendBufSize < 0) {
            throw new IllegalArgumentException("sendBufSize is less than 0");
        }
        if (recvBufSize == -1) {
            recvBufSize = 4096;
        } else if (recvBufSize < 0) {
            throw new IllegalArgumentException("recvBufSize is less than 0");
        }
        byte[] sendBufferBytes = new byte[sendBufSize];
        this.sendBuffer = ByteBuffer.wrap(sendBufferBytes);
        byte[] recvBufferBytes = new byte[recvBufSize];
        this.receiveBuffer = ByteBuffer.wrap(recvBufferBytes);
        this.sendPacket = new DatagramPacket(sendBufferBytes, sendBufSize);
        this.receivePacket = new DatagramPacket(recvBufferBytes, recvBufSize);
        this.readThread = readThread;
        this.writeThread = writeThread;
        this.worker = worker;
        log.tracef("Constructed a new channel (%s); send buffer size %d, receive buffer size %d", (Object)this, (Object)sendBufSize, (Object)recvBufSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open() {
        ThreadFactory threadFactory = Executors.defaultThreadFactory();
        Thread readThread = threadFactory.newThread(this.readerTask);
        boolean ok = false;
        try {
            Thread writeThread = threadFactory.newThread(this.writerTask);
            try {
                readThread.start();
                writeThread.start();
                ok = true;
            }
            finally {
                if (!ok) {
                    this.writerTask.cancel();
                }
            }
        }
        finally {
            if (!ok) {
                this.readerTask.cancel();
            }
        }
        log.tracef("Channel %s opened", (Object)this);
    }

    public NioSetter<BioDatagramUdpChannel> getReadSetter() {
        return this.readSetter;
    }

    public NioSetter<BioDatagramUdpChannel> getWriteSetter() {
        return this.writeSetter;
    }

    public NioSetter<BioDatagramUdpChannel> getCloseSetter() {
        return this.closeSetter;
    }

    public boolean flush() throws IOException {
        return true;
    }

    public SocketAddress getLocalAddress() {
        return this.datagramSocket.getLocalSocketAddress();
    }

    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        SocketAddress address = this.getLocalAddress();
        return (A)(type.isInstance(address) ? (SocketAddress)type.cast(address) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receiveFrom(SocketAddressBuffer addressBuffer, ByteBuffer buffer) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            if (!this.readable) {
                return 0;
            }
            this.readable = false;
            if (this.readException != null) {
                try {
                    this.readException.setStackTrace(new Throwable().getStackTrace());
                    throw this.readException;
                }
                catch (Throwable throwable) {
                    this.readException = null;
                    throw throwable;
                }
            }
            int size = Math.min(buffer.remaining(), this.receiveBuffer.remaining());
            this.receiveBuffer.limit(size);
            buffer.put(this.receiveBuffer);
            this.readLock.notify();
            SocketAddress socketAddress = this.receivePacket.getSocketAddress();
            if (addressBuffer != null) {
                addressBuffer.setSourceAddress(socketAddress);
                addressBuffer.setDestinationAddress(null);
            }
            return size;
        }
    }

    public long receiveFrom(SocketAddressBuffer addressBuffer, ByteBuffer[] buffers) throws IOException {
        return this.receiveFrom(addressBuffer, buffers, 0, buffers.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long receiveFrom(SocketAddressBuffer addressBuffer, ByteBuffer[] buffers, int offs, int len) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            if (!this.readable) {
                return 0L;
            }
            this.readable = false;
            if (this.readException != null) {
                try {
                    this.readException.setStackTrace(new Throwable().getStackTrace());
                    throw this.readException;
                }
                catch (Throwable throwable) {
                    this.readException = null;
                    throw throwable;
                }
            }
            int size = (int)Math.min(Buffers.remaining((Buffer[])buffers, (int)offs, (int)len), (long)this.receiveBuffer.remaining());
            this.receiveBuffer.limit(size);
            Buffers.copy((ByteBuffer[])buffers, (int)offs, (int)len, (ByteBuffer)this.receiveBuffer);
            this.readLock.notify();
            SocketAddress socketAddress = this.receivePacket.getSocketAddress();
            if (addressBuffer != null) {
                addressBuffer.setSourceAddress(socketAddress);
                addressBuffer.setDestinationAddress(null);
            }
            return size;
        }
    }

    public boolean isOpen() {
        return !this.datagramSocket.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closeCalled.getAndSet(true)) {
            Object object = this.writeLock;
            synchronized (object) {
                this.enableWrite = false;
            }
            object = this.readLock;
            synchronized (object) {
                this.enableRead = false;
            }
            try {
                this.readerTask.cancel();
            }
            catch (Throwable t) {
                log.tracef(t, "Reader task cancel failed", new Object[0]);
            }
            try {
                this.writerTask.cancel();
            }
            catch (Throwable t) {
                log.tracef(t, "Writer task cancel failed", new Object[0]);
            }
            object = this.writeLock;
            synchronized (object) {
                this.writable = false;
            }
            object = this.readLock;
            synchronized (object) {
                this.readable = false;
            }
            this.datagramSocket.close();
            ChannelListeners.invokeChannelListener((Channel)((Object)this), this.getCloseSetter().get());
            log.tracef("Closing channel %s", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendTo(SocketAddress target, ByteBuffer buffer) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (!this.writable) {
                return false;
            }
            this.sendBuffer.clear();
            if (this.sendBuffer.remaining() < buffer.remaining()) {
                throw new IOException("Insufficient room in send buffer (send will never succeed); send buffer is " + this.sendBuffer.remaining() + " bytes, but transmitted datagram is " + buffer.remaining() + " bytes");
            }
            this.sendBuffer.put(buffer);
            this.sendPacket.setSocketAddress(target);
            this.sendPacket.setData(this.sendBuffer.array(), this.sendBuffer.arrayOffset(), this.sendBuffer.position());
            this.writeLock.notifyAll();
            this.writable = false;
            return true;
        }
    }

    public boolean sendTo(SocketAddress target, ByteBuffer[] dsts) throws IOException {
        return this.sendTo(target, dsts, 0, dsts.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendTo(SocketAddress target, ByteBuffer[] dsts, int offset, int length) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            int i;
            if (!this.writable) {
                return false;
            }
            this.sendBuffer.clear();
            long t = 0L;
            for (i = 0; i < length; ++i) {
                t += (long)dsts[i + offset].remaining();
            }
            if ((long)this.sendBuffer.remaining() < t) {
                throw new IOException("Insufficient room in send buffer (send will never succeed); send buffer is " + this.sendBuffer.remaining() + " bytes, but transmitted datagram is " + t + " bytes");
            }
            for (i = 0; i < length; ++i) {
                this.sendBuffer.put(dsts[i + offset]);
            }
            this.sendPacket.setSocketAddress(target);
            this.sendPacket.setData(this.sendBuffer.array(), this.sendBuffer.arrayOffset(), this.sendBuffer.position());
            this.writeLock.notifyAll();
            this.writable = false;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendReads() {
        Object object = this.readLock;
        synchronized (object) {
            this.enableRead = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendWrites() {
        Object object = this.readLock;
        synchronized (object) {
            this.enableWrite = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeReads() {
        Object object = this.readLock;
        synchronized (object) {
            this.enableRead = true;
            if (this.readable) {
                WorkerThread readThread = this.readThread;
                if (readThread == null) {
                    throw new IllegalStateException("No read thread");
                }
                readThread.execute(this.readHandlerTask);
            }
            this.readLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadResumed() {
        Object object = this.readLock;
        synchronized (object) {
            return this.enableRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeWrites() {
        Object object = this.writeLock;
        synchronized (object) {
            this.enableWrite = true;
            if (this.writable) {
                WorkerThread writeThread = this.writeThread;
                if (writeThread == null) {
                    throw new IllegalStateException("No write thread");
                }
                writeThread.execute(this.writeHandlerTask);
            }
            this.writeLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWriteResumed() {
        Object object = this.writeLock;
        synchronized (object) {
            return this.enableWrite;
        }
    }

    public void wakeupReads() {
        this.resumeReads();
        WorkerThread readThread = this.readThread;
        if (readThread != null) {
            readThread.execute(this.readHandlerTask);
        }
    }

    public void wakeupWrites() {
        this.resumeWrites();
        WorkerThread writeThread = this.writeThread;
        if (writeThread != null) {
            writeThread.execute(this.writeHandlerTask);
        }
    }

    public void shutdownReads() throws IOException {
        throw new UnsupportedOperationException("Shutdown reads");
    }

    public boolean shutdownWrites() throws IOException {
        throw new UnsupportedOperationException("Shutdown writes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitReadable() throws IOException {
        try {
            Object object = this.readLock;
            synchronized (object) {
                if (!this.isOpen()) {
                    return;
                }
                while (!this.readable) {
                    this.readLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        try {
            Object object = this.readLock;
            synchronized (object) {
                if (!this.isOpen()) {
                    return;
                }
                if (!this.readable) {
                    timeUnit.timedWait(this.readLock, time);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public XnioExecutor getReadThread() {
        return this.readThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitWritable() throws IOException {
        try {
            Object object = this.writeLock;
            synchronized (object) {
                if (!this.isOpen()) {
                    return;
                }
                while (!this.writable) {
                    this.writeLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        try {
            Object object = this.writeLock;
            synchronized (object) {
                if (!this.isOpen()) {
                    return;
                }
                if (!this.writable) {
                    timeUnit.timedWait(this.writeLock, time);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public XnioExecutor getWriteThread() {
        return this.writeThread;
    }

    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option);
    }

    public <T> T getOption(Option<T> option) throws UnsupportedOptionException, IOException {
        if (Options.BROADCAST.equals(option)) {
            return (T)option.cast((Object)this.datagramSocket.getBroadcast());
        }
        if (Options.IP_TRAFFIC_CLASS.equals(option)) {
            int v = this.datagramSocket.getTrafficClass();
            return (T)(v == -1 ? null : option.cast((Object)v));
        }
        return null;
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        Comparable<Boolean> old;
        if (Options.BROADCAST.equals(option)) {
            old = this.datagramSocket.getBroadcast();
            this.datagramSocket.setBroadcast((Boolean)Options.BROADCAST.cast(value));
        } else if (Options.IP_TRAFFIC_CLASS.equals(option)) {
            old = this.datagramSocket.getTrafficClass();
            this.datagramSocket.setTrafficClass((Integer)Options.IP_TRAFFIC_CLASS.cast(value));
        } else {
            return null;
        }
        return (T)option.cast((Object)old);
    }

    public MulticastMessageChannel.Key join(InetAddress group, NetworkInterface iface) throws IOException {
        throw new UnsupportedOptionException("Multicast not supported");
    }

    public MulticastMessageChannel.Key join(InetAddress group, NetworkInterface iface, InetAddress source) throws IOException {
        throw new UnsupportedOptionException("Multicast not supported");
    }

    public XnioWorker getWorker() {
        return this.worker;
    }

    private final class WriteHandlerTask
    implements Runnable {
        private WriteHandlerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean writable;
            Object object = BioDatagramUdpChannel.this.writeLock;
            synchronized (object) {
                writable = BioDatagramUdpChannel.this.writable;
            }
            if (writable) {
                ChannelListeners.invokeChannelListener((Channel)((Object)BioDatagramUdpChannel.this), BioDatagramUdpChannel.this.getWriteSetter().get());
            }
        }
    }

    private final class ReadHandlerTask
    implements Runnable {
        private ReadHandlerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean readable;
            Object object = BioDatagramUdpChannel.this.readLock;
            synchronized (object) {
                readable = BioDatagramUdpChannel.this.readable;
            }
            if (readable) {
                ChannelListeners.invokeChannelListener((Channel)((Object)BioDatagramUdpChannel.this), BioDatagramUdpChannel.this.getReadSetter().get());
            }
        }
    }

    private final class WriterTask
    implements Runnable {
        private volatile Thread thread;

        private WriterTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.thread = Thread.currentThread();
            try {
                while (true) {
                    Object object = BioDatagramUdpChannel.this.writeLock;
                    synchronized (object) {
                        BioDatagramUdpChannel.this.writable = true;
                        while (BioDatagramUdpChannel.this.writable) {
                            if (BioDatagramUdpChannel.this.enableWrite) {
                                BioDatagramUdpChannel.this.enableWrite = false;
                                BioDatagramUdpChannel.this.wakeupWrites();
                            }
                            if (!BioDatagramUdpChannel.this.writable) continue;
                            try {
                                BioDatagramUdpChannel.this.writeLock.wait();
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                    }
                    try {
                        BioDatagramUdpChannel.this.datagramSocket.send(BioDatagramUdpChannel.this.sendPacket);
                    }
                    catch (IOException e) {
                        log.tracef("Packet send failed: %s", (Object)e);
                    }
                }
            }
            finally {
                this.thread = null;
                log.trace((Object)"Exiting thread");
            }
        }

        public void cancel() {
            Thread thread = this.thread;
            if (thread != null) {
                thread.interrupt();
            }
        }
    }

    private final class ReaderTask
    implements Runnable {
        private volatile Thread thread;

        private ReaderTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.thread = Thread.currentThread();
            try {
                while (true) {
                    Object object = BioDatagramUdpChannel.this.readLock;
                    synchronized (object) {
                        while (BioDatagramUdpChannel.this.readable) {
                            try {
                                log.trace((Object)"Waiting for user to consume read data");
                                BioDatagramUdpChannel.this.readLock.wait();
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                    }
                    try {
                        BioDatagramUdpChannel.this.datagramSocket.receive(BioDatagramUdpChannel.this.receivePacket);
                        log.trace((Object)"Packet received");
                    }
                    catch (IOException e) {
                        Object object2 = BioDatagramUdpChannel.this.readLock;
                        synchronized (object2) {
                            BioDatagramUdpChannel.this.readException = e;
                            BioDatagramUdpChannel.this.readable = true;
                            if (BioDatagramUdpChannel.this.enableRead) {
                                BioDatagramUdpChannel.this.wakeupReads();
                            }
                            continue;
                        }
                    }
                    object = BioDatagramUdpChannel.this.readLock;
                    synchronized (object) {
                        BioDatagramUdpChannel.this.receiveBuffer.limit(BioDatagramUdpChannel.this.receivePacket.getLength());
                        BioDatagramUdpChannel.this.receiveBuffer.position(0);
                        BioDatagramUdpChannel.this.readable = true;
                        if (BioDatagramUdpChannel.this.enableRead) {
                            BioDatagramUdpChannel.this.wakeupReads();
                        }
                    }
                }
            }
            finally {
                this.thread = null;
                log.trace((Object)"Exiting thread");
            }
        }

        public void cancel() {
            Thread thread = this.thread;
            if (thread != null) {
                thread.interrupt();
            }
        }
    }
}

