/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.xml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.weld.logging.messages.XmlMessage;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.xml.EnabledClasses;
import org.jboss.weld.xml.MergedElements;
import org.jboss.weld.xml.WeldXmlException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansXmlParser {
    private final Iterable<URL> beansXmls;
    private final ResourceLoader resourceLoader;
    private EnabledClasses enabledClasses = null;

    public List<Class<?>> getEnabledAlternativeClasses() {
        return this.enabledClasses.getEnabledAlternativeClasses();
    }

    public List<Class<? extends Annotation>> getEnabledAlternativeStereotypes() {
        return this.enabledClasses.getEnabledAlternativeStereotypes();
    }

    public List<Class<?>> getEnabledDecoratorClasses() {
        return this.enabledClasses.getEnabledDecoratorClasses();
    }

    public List<Class<?>> getEnabledInterceptorClasses() {
        return this.enabledClasses.getEnabledInterceptorClasses();
    }

    public BeansXmlParser(ResourceLoader resourceLoader, Iterable<URL> beansXml) {
        this.beansXmls = beansXml;
        this.resourceLoader = resourceLoader;
    }

    public void parse() {
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        MergedElements mergedElements = new MergedElements();
        for (URL beansXml : this.beansXmls) {
            if (!this.isBeansXmlOK(beansXml)) continue;
            Document document = this.getDocument(documentBuilder, beansXml);
            mergedElements.merge(beansXml, document);
        }
        this.enabledClasses = EnabledClasses.of(mergedElements, this.resourceLoader);
    }

    private Document getDocument(DocumentBuilder documentBuilder, URL beansXml) {
        Document document;
        InputStream in = null;
        try {
            in = beansXml.openStream();
            document = documentBuilder.parse(in);
            document.normalize();
        }
        catch (SAXException e) {
            throw new WeldXmlException(XmlMessage.PARSING_ERROR, e, beansXml.toString());
        }
        catch (IOException e) {
            throw new WeldXmlException(XmlMessage.LOAD_ERROR, e, beansXml.toString());
        }
        finally {
            this.closeStream(in);
        }
        return document;
    }

    private void closeStream(InputStream in) {
        if (in == null) {
            return;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isBeansXmlOK(URL beansXml) {
        if (beansXml == null) {
            throw new WeldXmlException(XmlMessage.LOAD_ERROR, "URL: null");
        }
        InputStream in = null;
        try {
            in = beansXml.openStream();
            boolean bl = in.available() > 0;
            return bl;
        }
        catch (IOException e) {
            throw new WeldXmlException(XmlMessage.LOAD_ERROR, e, beansXml.toString());
        }
        finally {
            this.closeStream(in);
        }
    }

    private DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new WeldXmlException(XmlMessage.CONFIGURATION_ERROR, e);
        }
    }
}

