/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api.asset;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.asset.Asset;

public class StringAsset
implements Asset {
    private static final Logger log = Logger.getLogger(StringAsset.class.getName());
    private final String content;

    public StringAsset(String content) {
        if (content == null) {
            throw new IllegalArgumentException("content must be specified");
        }
        this.content = content;
        if (log.isLoggable(Level.FINER)) {
            log.finer("Created " + this + " with backing String of size " + content.length() + "b");
        }
    }

    public InputStream openStream() {
        return new ByteArrayInputStream(this.content.getBytes());
    }

    public String toString() {
        return StringAsset.class.getSimpleName() + " [content size=" + this.content.length() + " bytes]";
    }
}

