/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.io.InputStream;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NoContentException;
import org.jboss.resteasy.util.NoContentInputStreamDelegate;

public class NoContent {
    public static InputStream noContentCheck(MultivaluedMap httpHeaders, InputStream is) throws NoContentException {
        NoContent.contentLengthCheck(httpHeaders);
        NoContentInputStreamDelegate delegate = new NoContentInputStreamDelegate(is);
        return delegate;
    }

    public static boolean isContentLengthZero(MultivaluedMap httpHeaders) {
        long length;
        if (httpHeaders == null) {
            return false;
        }
        String contentLength = (String)httpHeaders.getFirst((Object)"Content-Length");
        return contentLength != null && (length = Long.parseLong(contentLength)) == 0L;
    }

    public static void contentLengthCheck(MultivaluedMap httpHeaders) throws NoContentException {
        if (NoContent.isContentLengthZero(httpHeaders)) {
            throw new NoContentException("No content.  Content-Length is 0");
        }
    }
}

