/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import org.jboss.resteasy.logging.Logger;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExternalEntityUnmarshaller
implements Unmarshaller {
    static final Logger log = Logger.getLogger(ExternalEntityUnmarshaller.class);
    private Unmarshaller delegate;

    public ExternalEntityUnmarshaller(Unmarshaller delegate) {
        this.delegate = delegate;
    }

    public <A extends XmlAdapter> A getAdapter(Class<A> type) {
        return (A)this.delegate.getAdapter(type);
    }

    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        return this.delegate.getAttachmentUnmarshaller();
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.delegate.getEventHandler();
    }

    public Unmarshaller.Listener getListener() {
        return this.delegate.getListener();
    }

    public Object getProperty(String name) throws PropertyException {
        return this.delegate.getProperty(name);
    }

    public Schema getSchema() {
        return this.delegate.getSchema();
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        return this.delegate.getUnmarshallerHandler();
    }

    @Deprecated
    public boolean isValidating() throws JAXBException {
        return this.delegate.isValidating();
    }

    @Deprecated
    public void setAdapter(XmlAdapter adapter) {
        this.delegate.setAdapter(adapter);
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> type, A adapter) {
        this.delegate.setAdapter(adapter);
    }

    public void setAttachmentUnmarshaller(AttachmentUnmarshaller au) {
        this.delegate.setAttachmentUnmarshaller(au);
    }

    public void setEventHandler(ValidationEventHandler handler) throws JAXBException {
        this.delegate.setEventHandler(handler);
    }

    public void setListener(Unmarshaller.Listener listener) {
        this.delegate.setListener(listener);
    }

    public void setProperty(String name, Object value) throws PropertyException {
        this.delegate.setProperty(name, value);
    }

    public void setSchema(Schema schema) {
        this.delegate.setSchema(schema);
    }

    @Deprecated
    public void setValidating(boolean validating) throws JAXBException {
        this.delegate.setValidating(validating);
    }

    public Object unmarshal(File f) throws JAXBException {
        throw new UnsupportedOperationException(this.errorMessage("File"));
    }

    public Object unmarshal(InputStream is) throws JAXBException {
        return this.unmarshal(new InputSource(is));
    }

    public Object unmarshal(Reader reader) throws JAXBException {
        throw new UnsupportedOperationException(this.errorMessage("Reader"));
    }

    public Object unmarshal(URL url) throws JAXBException {
        throw new UnsupportedOperationException(this.errorMessage("URL"));
    }

    public Object unmarshal(InputSource source) throws JAXBException {
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/validation", false);
            xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            SAXSource saxSource = new SAXSource(xmlReader, source);
            return this.delegate.unmarshal((Source)saxSource);
        }
        catch (SAXException e) {
            throw new JAXBException((Throwable)e);
        }
    }

    public Object unmarshal(Node node) throws JAXBException {
        return this.delegate.unmarshal(node);
    }

    public Object unmarshal(Source source) throws JAXBException {
        throw new UnsupportedOperationException(this.errorMessage("Source"));
    }

    public Object unmarshal(XMLStreamReader reader) throws JAXBException {
        throw new UnsupportedOperationException(this.errorMessage("XMLStreamReader"));
    }

    public Object unmarshal(XMLEventReader reader) throws JAXBException {
        throw new UnsupportedOperationException(this.errorMessage("XMLEventReader"));
    }

    public <T> JAXBElement<T> unmarshal(Node node, Class<T> declaredType) throws JAXBException {
        throw new UnsupportedOperationException(this.errorMessage("Node, Class<T>"));
    }

    public <T> JAXBElement<T> unmarshal(Source source, Class<T> declaredType) throws JAXBException {
        if (source instanceof SAXSource) {
            try {
                XMLReader xmlReader = XMLReaderFactory.createXMLReader();
                xmlReader.setFeature("http://xml.org/sax/features/validation", false);
                xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                ((SAXSource)source).setXMLReader(xmlReader);
                return this.delegate.unmarshal(source, declaredType);
            }
            catch (SAXException e) {
                throw new JAXBException((Throwable)e);
            }
        }
        throw new UnsupportedOperationException(this.errorMessage("Source, Class<T>"));
    }

    public <T> JAXBElement<T> unmarshal(XMLStreamReader reader, Class<T> declaredType) throws JAXBException {
        throw new UnsupportedOperationException(this.errorMessage("XMLStreamReader, Class<T>"));
    }

    public <T> JAXBElement<T> unmarshal(XMLEventReader reader, Class<T> declaredType) throws JAXBException {
        throw new UnsupportedOperationException(this.errorMessage("XMLEventReader, Class<T>"));
    }

    public Unmarshaller getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Unmarshaller delegate) {
        this.delegate = delegate;
    }

    private String errorMessage(String s) {
        return "ExternalEntityUnmarshallerWrapper: unexpected use of unmarshal(" + s + ")";
    }
}

