/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs;

import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.apache.http.HttpHost;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngineBuilder4;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngineBuilder43;
import org.jboss.resteasy.client.jaxrs.HTTPClientVersionCheck;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpAsyncClient4Engine;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.LocalResteasyProviderFactory;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ResteasyClientBuilder
extends ClientBuilder {
    protected KeyStore truststore;
    protected KeyStore clientKeyStore;
    protected String clientPrivateKeyPassword;
    protected boolean disableTrustManager;
    protected HostnameVerificationPolicy policy = HostnameVerificationPolicy.WILDCARD;
    protected ResteasyProviderFactory providerFactory;
    protected ExecutorService asyncExecutor;
    protected ScheduledExecutorService scheduledExecutorService;
    protected boolean cleanupExecutor;
    protected SSLContext sslContext;
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected ClientHttpEngine httpEngine;
    protected int connectionPoolSize = 50;
    protected int maxPooledPerRoute = 0;
    protected long connectionTTL = -1L;
    protected TimeUnit connectionTTLUnit = TimeUnit.MILLISECONDS;
    protected long socketTimeout = -1L;
    protected TimeUnit socketTimeoutUnits = TimeUnit.MILLISECONDS;
    protected long establishConnectionTimeout = -1L;
    protected TimeUnit establishConnectionTimeoutUnits = TimeUnit.MILLISECONDS;
    protected int connectionCheckoutTimeoutMs = -1;
    protected HostnameVerifier verifier = null;
    protected HttpHost defaultProxy;
    protected int responseBufferSize;
    protected List<String> sniHostNames = new ArrayList<String>();

    public ResteasyClientBuilder providerFactory(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
        return this;
    }

    @Deprecated
    public ResteasyClientBuilder asyncExecutor(ExecutorService asyncExecutor) {
        return this.asyncExecutor(asyncExecutor, false);
    }

    @Deprecated
    public ResteasyClientBuilder asyncExecutor(ExecutorService asyncExecutor, boolean cleanupExecutor) {
        this.asyncExecutor = asyncExecutor;
        this.cleanupExecutor = cleanupExecutor;
        return this;
    }

    public ResteasyClientBuilder connectionTTL(long ttl, TimeUnit unit) {
        this.connectionTTL = ttl;
        this.connectionTTLUnit = unit;
        return this;
    }

    public ResteasyClientBuilder readTimeout(long timeout, TimeUnit unit) {
        this.socketTimeout = timeout;
        this.socketTimeoutUnits = unit;
        return this;
    }

    @Deprecated
    public ResteasyClientBuilder socketTimeout(long timeout, TimeUnit unit) {
        return this.readTimeout(timeout, unit);
    }

    public ResteasyClientBuilder connectTimeout(long timeout, TimeUnit unit) {
        this.establishConnectionTimeout = timeout;
        this.establishConnectionTimeoutUnits = unit;
        return this;
    }

    @Deprecated
    public ResteasyClientBuilder establishConnectionTimeout(long timeout, TimeUnit unit) {
        return this.connectTimeout(timeout, unit);
    }

    public ResteasyClientBuilder maxPooledPerRoute(int maxPooledPerRoute) {
        this.maxPooledPerRoute = maxPooledPerRoute;
        return this;
    }

    public ResteasyClientBuilder connectionCheckoutTimeout(long timeout, TimeUnit unit) {
        this.connectionCheckoutTimeoutMs = (int)TimeUnit.MILLISECONDS.convert(timeout, unit);
        return this;
    }

    public ResteasyClientBuilder connectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
        return this;
    }

    public ResteasyClientBuilder responseBufferSize(int size) {
        this.responseBufferSize = size;
        return this;
    }

    public ResteasyClientBuilder disableTrustManager() {
        this.disableTrustManager = true;
        return this;
    }

    public ResteasyClientBuilder hostnameVerification(HostnameVerificationPolicy policy) {
        this.policy = policy;
        return this;
    }

    public ResteasyClientBuilder httpEngine(ClientHttpEngine httpEngine) {
        this.httpEngine = httpEngine;
        return this;
    }

    public ResteasyClientBuilder useAsyncHttpEngine() {
        this.httpEngine = new ApacheHttpAsyncClient4Engine(HttpAsyncClients.createSystem(), true);
        return this;
    }

    public ResteasyClientBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public ResteasyClientBuilder trustStore(KeyStore truststore) {
        this.truststore = truststore;
        return this;
    }

    public ResteasyClientBuilder keyStore(KeyStore keyStore, String password) {
        this.clientKeyStore = keyStore;
        this.clientPrivateKeyPassword = password;
        return this;
    }

    public ResteasyClientBuilder keyStore(KeyStore keyStore, char[] password) {
        this.clientKeyStore = keyStore;
        this.clientPrivateKeyPassword = new String(password);
        return this;
    }

    public ResteasyClientBuilder property(String name, Object value) {
        this.getProviderFactory().property(name, value);
        return this;
    }

    public ResteasyClientBuilder sniHostNames(String ... sniHostNames) {
        this.sniHostNames.addAll(Arrays.asList(sniHostNames));
        return this;
    }

    public ResteasyClientBuilder defaultProxy(String hostname) {
        return this.defaultProxy(hostname, -1, null);
    }

    public ResteasyClientBuilder defaultProxy(String hostname, int port) {
        return this.defaultProxy(hostname, port, null);
    }

    public ResteasyClientBuilder defaultProxy(String hostname, int port, String scheme) {
        this.defaultProxy = new HttpHost(hostname, port, scheme);
        return this;
    }

    protected ResteasyProviderFactory getProviderFactory() {
        if (this.providerFactory == null) {
            this.providerFactory = new LocalResteasyProviderFactory(ResteasyProviderFactory.newInstance());
            RegisterBuiltin.register((ResteasyProviderFactory)this.providerFactory);
        }
        return this.providerFactory;
    }

    @Deprecated
    public ResteasyClient buildOld() {
        ClientConfiguration config = new ClientConfiguration(this.getProviderFactory());
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            config.property(entry.getKey(), entry.getValue());
        }
        ExecutorService executor = this.asyncExecutor;
        if (executor == null) {
            this.cleanupExecutor = true;
            executor = Executors.newFixedThreadPool(10);
        }
        ClientHttpEngine engine = this.httpEngine != null ? this.httpEngine : new ClientHttpEngineBuilder4().resteasyClientBuilder(this).build();
        return this.createResteasyClient(engine, executor, this.cleanupExecutor, this.scheduledExecutorService, config);
    }

    public ResteasyClient build() {
        if (HTTPClientVersionCheck.isUseOldHTTPClient() || !HTTPClientVersionCheck.isNewHTTPClientAvailable()) {
            return this.buildOld();
        }
        ClientConfiguration config = new ClientConfiguration(this.getProviderFactory());
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            config.property(entry.getKey(), entry.getValue());
        }
        ExecutorService executor = this.asyncExecutor;
        if (executor == null) {
            this.cleanupExecutor = true;
            executor = Executors.newFixedThreadPool(10);
        }
        ClientHttpEngine engine = this.httpEngine != null ? this.httpEngine : new ClientHttpEngineBuilder43().resteasyClientBuilder(this).build();
        return this.createResteasyClient(engine, executor, this.cleanupExecutor, this.scheduledExecutorService, config);
    }

    protected ResteasyClient createResteasyClient(ClientHttpEngine engine, ExecutorService executor, boolean cleanupExecutor, ScheduledExecutorService scheduledExecutorService, ClientConfiguration config) {
        return new ResteasyClient(engine, executor, cleanupExecutor, scheduledExecutorService, config);
    }

    protected void prepareSocketForSni(SSLSocket socket) {
        if (!this.sniHostNames.isEmpty()) {
            ArrayList<SNIServerName> sniNames = new ArrayList<SNIServerName>(this.sniHostNames.size());
            for (String sniHostName : this.sniHostNames) {
                sniNames.add(new SNIHostName(sniHostName));
            }
            SSLParameters sslParameters = socket.getSSLParameters();
            sslParameters.setServerNames(sniNames);
            socket.setSSLParameters(sslParameters);
        }
    }

    public ResteasyClientBuilder hostnameVerifier(HostnameVerifier verifier) {
        this.verifier = verifier;
        return this;
    }

    public Configuration getConfiguration() {
        return this.getProviderFactory().getConfiguration();
    }

    public ResteasyClientBuilder register(Class<?> componentClass) {
        this.getProviderFactory().register(componentClass);
        return this;
    }

    public ResteasyClientBuilder register(Class<?> componentClass, int priority) {
        this.getProviderFactory().register(componentClass, priority);
        return this;
    }

    public ResteasyClientBuilder register(Class<?> componentClass, Class<?> ... contracts) {
        this.getProviderFactory().register(componentClass, (Class[])contracts);
        return this;
    }

    public ResteasyClientBuilder register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.getProviderFactory().register(componentClass, contracts);
        return this;
    }

    public ResteasyClientBuilder register(Object component) {
        this.getProviderFactory().register(component);
        return this;
    }

    public ResteasyClientBuilder register(Object component, int priority) {
        this.getProviderFactory().register(component, priority);
        return this;
    }

    public ResteasyClientBuilder register(Object component, Class<?> ... contracts) {
        this.getProviderFactory().register(component, (Class[])contracts);
        return this;
    }

    public ResteasyClientBuilder register(Object component, Map<Class<?>, Integer> contracts) {
        this.getProviderFactory().register(component, contracts);
        return this;
    }

    public ResteasyClientBuilder withConfig(Configuration config) {
        Map contracts;
        this.providerFactory = new LocalResteasyProviderFactory(new ResteasyProviderFactory());
        this.providerFactory.setProperties(config.getProperties());
        for (Class clazz : config.getClasses()) {
            contracts = config.getContracts(clazz);
            try {
                this.register(clazz, contracts);
            }
            catch (RuntimeException e) {
                throw new RuntimeException(Messages.MESSAGES.failedOnRegisteringClass(clazz.getName()), e);
            }
        }
        for (Object obj : config.getInstances()) {
            contracts = config.getContracts(obj.getClass());
            this.register(obj, contracts);
        }
        return this;
    }

    public ClientBuilder executorService(ExecutorService executorService) {
        return this.asyncExecutor(executorService, false);
    }

    public ClientBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
        return this;
    }

    public static enum HostnameVerificationPolicy {
        ANY,
        WILDCARD,
        STRICT;

    }
}

