/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.ReaderInterceptor;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.core.ProvidersContextRetainer;
import org.jboss.resteasy.core.interception.ClientReaderInterceptorContext;
import org.jboss.resteasy.specimpl.AbstractBuiltResponse;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.HeaderValueProcessor;
import org.jboss.resteasy.spi.MarshalledEntity;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.InputStreamToByteArray;
import org.jboss.resteasy.util.ReadFromStream;
import org.jboss.resteasy.util.Types;

public abstract class ClientResponse
extends BuiltResponse {
    protected Map<String, Object> properties;
    protected ClientConfiguration configuration;

    protected ClientResponse(ClientConfiguration configuration) {
        this.setClientConfiguration(configuration);
    }

    public void setHeaders(MultivaluedMap<String, String> headers) {
        this.metadata = new Headers();
        this.metadata.putAll(headers);
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setClientConfiguration(ClientConfiguration configuration) {
        this.configuration = configuration;
        this.processor = configuration;
    }

    public synchronized Object getEntity() {
        this.abortIfClosed();
        Object entity = super.getEntity();
        if (entity != null) {
            return this.checkEntityReadAsInputStreamFullyConsumed(entity);
        }
        return this.checkEntityReadAsInputStreamFullyConsumed(this.getEntityStream());
    }

    private <T> T checkEntityReadAsInputStreamFullyConsumed(T entity) {
        if (this.bufferedEntity == null && entity instanceof InputStream && this.streamFullyRead) {
            throw new IllegalStateException();
        }
        return entity;
    }

    public Class<?> getEntityClass() {
        Class classs = super.getEntityClass();
        if (classs != null) {
            return classs;
        }
        Object entity = null;
        try {
            entity = this.getEntity();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entity != null ? entity.getClass() : null;
    }

    public boolean hasEntity() {
        this.abortIfClosed();
        return this.getInputStream() != null && (this.entity != null || this.getMediaType() != null);
    }

    public void noReleaseConnection() {
        this.isClosed = true;
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        try {
            this.isClosed = true;
            this.releaseConnection();
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    protected synchronized void finalize() throws Throwable {
        if (this.isClosed()) {
            return;
        }
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected HeaderValueProcessor getHeaderValueProcessor() {
        return this.configuration;
    }

    protected InputStream getEntityStream() {
        if (this.bufferedEntity != null) {
            return new ByteArrayInputStream(this.bufferedEntity);
        }
        if (this.isClosed()) {
            throw new ProcessingException(Messages.MESSAGES.streamIsClosed());
        }
        InputStream is = this.getInputStream();
        return is != null ? new AbstractBuiltResponse.InputStreamWrapper(is, (BuiltResponse)this) : null;
    }

    protected abstract void setInputStream(InputStream var1);

    protected synchronized <T> Object readFrom(Class<T> type, Type genericType, MediaType media, Annotation[] annotations) {
        Type useGeneric = genericType == null ? type : genericType;
        Class useType = type;
        media = media == null ? MediaType.WILDCARD_TYPE : media;
        annotations = annotations == null ? this.annotations : annotations;
        boolean isMarshalledEntity = false;
        if (type.equals(MarshalledEntity.class)) {
            isMarshalledEntity = true;
            ParameterizedType param = (ParameterizedType)useGeneric;
            useGeneric = param.getActualTypeArguments()[0];
            useType = Types.getRawType(useGeneric);
        }
        Providers current = (Providers)ResteasyProviderFactory.getContextData(Providers.class);
        ResteasyProviderFactory.pushContext(Providers.class, (Object)this.configuration);
        Object obj = null;
        try {
            Object finalObj;
            InputStream is = this.getEntityStream();
            if (is == null) {
                throw new IllegalStateException(Messages.MESSAGES.inputStreamWasEmpty());
            }
            if (isMarshalledEntity) {
                is = new InputStreamToByteArray(is);
            }
            ReaderInterceptor[] readerInterceptors = this.configuration.getReaderInterceptors(null, null);
            obj = finalObj = new ClientReaderInterceptorContext(readerInterceptors, this.configuration.getProviderFactory(), useType, useGeneric, annotations, media, this.getStringHeaders(), is, this.properties).proceed();
            if (isMarshalledEntity) {
                InputStreamToByteArray isba = (InputStreamToByteArray)is;
                final byte[] bytes = isba.toByteArray();
                MarshalledEntity<Object> marshalledEntity = new MarshalledEntity<Object>(){

                    public byte[] getMarshalledBytes() {
                        return bytes;
                    }

                    public Object getEntity() {
                        return finalObj;
                    }
                };
                return marshalledEntity;
            }
            Object object = finalObj;
            return object;
        }
        catch (ProcessingException pe) {
            throw pe;
        }
        catch (Exception ex) {
            throw new ProcessingException((Throwable)ex);
        }
        finally {
            ResteasyProviderFactory.popContextData(Providers.class);
            if (current != null) {
                ResteasyProviderFactory.pushContext(Providers.class, (Object)current);
            }
            if (obj instanceof ProvidersContextRetainer) {
                ((ProvidersContextRetainer)obj).setProviders((Providers)this.configuration);
            }
        }
    }

    public boolean bufferEntity() {
        this.abortIfClosed();
        if (this.bufferedEntity != null) {
            return true;
        }
        if (this.streamRead) {
            return false;
        }
        if (this.metadata.getFirst((Object)"Content-Type") == null) {
            return false;
        }
        InputStream is = this.getInputStream();
        if (is == null) {
            return false;
        }
        try {
            this.bufferedEntity = ReadFromStream.readFromStream((int)1024, (InputStream)is);
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
        finally {
            try {
                this.releaseConnection();
            }
            catch (IOException e) {
                throw new ProcessingException((Throwable)e);
            }
        }
        return true;
    }

    public void abortIfClosed() {
        if (this.bufferedEntity == null) {
            super.abortIfClosed();
        }
    }
}

