/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.util.CaseInsensitiveMap;
import org.jboss.resteasy.util.DateUtil;
import org.jboss.resteasy.util.HeaderHelper;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.WeightedLanguage;

public class ClientRequestHeaders {
    protected CaseInsensitiveMap<Object> headers = new CaseInsensitiveMap();
    protected ClientConfiguration configuration;

    public ClientRequestHeaders(ClientConfiguration configuration) {
        this.configuration = configuration;
    }

    public CaseInsensitiveMap<Object> getHeaders() {
        return this.headers;
    }

    public void setHeaders(MultivaluedMap<String, Object> newHeaders) {
        this.headers.clear();
        this.headers.putAll(newHeaders);
    }

    public void setLanguage(Locale language) {
        this.header("Content-Language", language);
    }

    public void setLanguage(String language) {
        this.setLanguage(new Locale(language));
    }

    public void setMediaType(MediaType mediaType) {
        this.header("Content-Type", mediaType);
    }

    public void acceptLanguage(Locale ... locales) {
        this.headers.remove((Object)"Accept-Language");
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (Locale l : locales) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            builder.append(l.toString());
        }
        this.headers.putSingle("Accept-Language", (Object)builder.toString());
    }

    public void acceptLanguage(String ... locales) {
        this.headers.remove((Object)"Accept-Language");
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (String l : locales) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            builder.append(l.toString());
        }
        this.headers.putSingle("Accept-Language", (Object)builder.toString());
    }

    public void accept(String ... types) {
        this.headers.remove((Object)"Accept");
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (String l : types) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            builder.append(l.toString());
        }
        this.headers.putSingle("Accept", (Object)builder.toString());
    }

    public void accept(MediaType ... types) {
        this.headers.remove((Object)"Accept");
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (MediaType l : types) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            builder.append(l.toString());
        }
        this.headers.putSingle("Accept", (Object)builder.toString());
    }

    public void cookie(Cookie cookie) {
        this.headers.add("Cookie", (Object)cookie);
    }

    public void allow(String ... methods) {
        HeaderHelper.setAllow(this.headers, (String[])methods);
    }

    public void allow(Set<String> methods) {
        HeaderHelper.setAllow(this.headers, methods);
    }

    public void cacheControl(CacheControl cacheControl) {
        this.headers.putSingle("Cache-Control", (Object)cacheControl);
    }

    public void header(String name, Object value) {
        if (value == null) {
            this.headers.remove((Object)name);
            return;
        }
        this.headers.add(name, value);
    }

    public Date getDate() {
        Object d = this.headers.getFirst("Date");
        if (d == null) {
            return null;
        }
        if (d instanceof Date) {
            return (Date)d;
        }
        return DateUtil.parseDate((String)d.toString());
    }

    public String getHeader(String name) {
        List vals = this.headers.get((Object)name);
        if (vals == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Object val : vals) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(this.configuration.toHeaderString(val));
        }
        return builder.toString();
    }

    public MultivaluedMap<String, String> asMap() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        for (Map.Entry entry : this.headers.entrySet()) {
            for (Object obj : (List)entry.getValue()) {
                map.add((String)entry.getKey(), (Object)this.configuration.toHeaderString(obj));
            }
        }
        return map;
    }

    public Locale getLanguage() {
        Object obj = this.headers.getFirst("Content-Language");
        if (obj == null) {
            return null;
        }
        if (obj instanceof Locale) {
            return (Locale)obj;
        }
        return new Locale(obj.toString());
    }

    public int getLength() {
        return -1;
    }

    public MediaType getMediaType() {
        Object obj = this.headers.getFirst("Content-Type");
        if (obj == null) {
            return null;
        }
        if (obj instanceof MediaType) {
            return (MediaType)obj;
        }
        return MediaType.valueOf((String)this.configuration.toHeaderString(obj));
    }

    public List<MediaType> getAcceptableMediaTypes() {
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        List accepts = this.headers.get((Object)"Accept");
        if (accepts == null) {
            return list;
        }
        for (Object obj : accepts) {
            if (obj instanceof MediaType) {
                list.add((MediaType)obj);
                continue;
            }
            String accept = null;
            accept = obj instanceof String ? (String)obj : this.configuration.toHeaderString(obj);
            StringTokenizer tokenizer = new StringTokenizer(accept, ",");
            while (tokenizer.hasMoreElements()) {
                String item = tokenizer.nextToken().trim();
                list.add(MediaType.valueOf((String)item));
            }
        }
        MediaTypeHelper.sortByWeight(list);
        return list;
    }

    public List<Locale> getAcceptableLanguages() {
        ArrayList<Locale> list = new ArrayList<Locale>();
        List accepts = this.headers.get((Object)"Accept-Language");
        if (accepts == null) {
            return list;
        }
        ArrayList<WeightedLanguage> languages = new ArrayList<WeightedLanguage>();
        for (Object obj : accepts) {
            if (obj instanceof Locale) {
                languages.add(new WeightedLanguage((Locale)obj, 1.0f));
                continue;
            }
            String accept = this.configuration.toHeaderString(obj);
            StringTokenizer tokenizer = new StringTokenizer(accept, ",");
            while (tokenizer.hasMoreElements()) {
                String item = tokenizer.nextToken().trim();
                languages.add(WeightedLanguage.parse((String)item));
            }
        }
        Collections.sort(languages);
        for (WeightedLanguage language : languages) {
            list.add(language.getLocale());
        }
        return list;
    }

    public Map<String, Cookie> getCookies() {
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        List list = this.headers.get((Object)"Cookie");
        if (list == null) {
            return cookies;
        }
        for (Object obj : list) {
            if (obj instanceof Cookie) {
                Cookie cookie = (Cookie)obj;
                cookies.put(cookie.getName(), cookie);
                continue;
            }
            String str = this.configuration.toHeaderString(obj);
            Cookie cookie = Cookie.valueOf((String)str);
            cookies.put(cookie.getName(), cookie);
        }
        return cookies;
    }
}

