/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.QSChecker;
import org.jboss.maven.plugins.qstools.Violation;
import org.jboss.maven.plugins.qstools.checkers.AbstractProjectChecker;
import org.w3c.dom.Document;

@Component(role=QSChecker.class, hint="readmeChecker")
public class ReadmeChecker
extends AbstractProjectChecker {
    private static final String[] README_METADATA = new String[]{"Author:", "Level:", "Technologies:", "Summary:", "Target Product:", "Source:"};
    private String regexPattern;
    private String folderName;

    @Override
    public String getCheckerDescription() {
        return "Checks if README.md metadata is defined and if the title matches the folder name";
    }

    @Override
    public void processProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        this.folderName = project.getBasedir().getName() + ":";
        this.setupRegexPattern();
        File readme = new File(project.getBasedir(), "README.md");
        if (readme.exists()) {
            this.checkReadmeFile(readme, results);
        }
    }

    private void setupRegexPattern() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < README_METADATA.length; ++i) {
            String metadata = README_METADATA[i];
            sb.append(metadata + "|");
        }
        sb.append(this.folderName);
        this.regexPattern = sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReadmeFile(File readme, Map<String, List<Violation>> results) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(readme));
        try {
            Pattern p = Pattern.compile(this.regexPattern);
            ArrayList<String> usedPatterns = new ArrayList<String>();
            while (br.ready()) {
                String line = br.readLine();
                Matcher m = p.matcher(line);
                if (!m.find()) continue;
                usedPatterns.add(m.group());
            }
            for (String metadata : README_METADATA) {
                if (usedPatterns.contains(metadata)) continue;
                String msg = "File doesn't containt [%s] metadata";
                this.addViolation(readme, results, 3, String.format(msg, metadata));
            }
            if (!usedPatterns.contains(this.folderName)) {
                String msg = "Readme title doesn't match the folder name: " + this.folderName;
                this.addViolation(readme, results, 1, msg);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }
}

