/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.QSChecker;
import org.jboss.maven.plugins.qstools.Violation;
import org.jboss.maven.plugins.qstools.checkers.AbstractProjectChecker;
import org.jboss.maven.plugins.qstools.maven.MavenDependency;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(role=QSChecker.class, hint="propertiesNameChecker")
public class PropertiesNameChecker
extends AbstractProjectChecker {
    private static Properties recommendedPropertiesNames;

    @Override
    public String getCheckerDescription() {
        return "Checks if POM properties are using standard names";
    }

    @Override
    public void processProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        if (recommendedPropertiesNames == null) {
            recommendedPropertiesNames = new Properties();
            recommendedPropertiesNames.load(this.getClass().getResourceAsStream("/properties_names.properties"));
        }
        NodeList dependencies = (NodeList)this.getxPath().evaluate("/project/dependencies/dependency", doc, XPathConstants.NODESET);
        for (int x = 0; x < dependencies.getLength(); ++x) {
            String version;
            Node dependency = dependencies.item(x);
            MavenDependency mavenDependency = this.getDependencyProvider().getDependencyFromNode(project, dependency);
            String groupId = mavenDependency.getGroupId();
            String artifactId = mavenDependency.getArtifactId();
            String string = version = mavenDependency.getDeclaredVersion() == null ? null : mavenDependency.getDeclaredVersion().replaceAll("[${}]", "");
            if (groupId == null || version == null || !recommendedPropertiesNames.containsKey(groupId) || recommendedPropertiesNames.get(groupId).equals(version)) continue;
            int lineNumber = this.getLineNumberFromNode(dependency);
            String recommendedName = recommendedPropertiesNames.getProperty(groupId);
            String msg = "Version for [%s:%s:%s] isn't using the recommended property name: %s";
            this.addViolation(project.getFile(), results, lineNumber, String.format(msg, groupId, artifactId, mavenDependency.getDeclaredVersion(), recommendedName));
        }
    }
}

