/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.QSChecker;
import org.jboss.maven.plugins.qstools.Violation;
import org.jboss.maven.plugins.qstools.checkers.AbstractProjectChecker;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Component(role=QSChecker.class, hint="GroupIdChecker")
public class GroupIdChecker
extends AbstractProjectChecker {
    @Override
    public String getCheckerDescription() {
        return "Check if the groupdId is 'org.jboss.as.quickstarts'";
    }

    @Override
    public void processProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        Node node = (Node)this.getxPath().evaluate("/project/groupId", doc, XPathConstants.NODE);
        if (!project.getGroupId().equals("org.jboss.as.quickstarts")) {
            int lineNumber = this.getLineNumberFromNode(node);
            this.addViolation(project.getFile(), results, lineNumber, "The project doesn't use groupId 'org.jboss.as.quickstarts'");
        }
    }
}

