/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.QSChecker;
import org.jboss.maven.plugins.qstools.Violation;
import org.jboss.maven.plugins.qstools.checkers.AbstractProjectChecker;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(role=QSChecker.class, hint="finalNameChecker")
public class FinalNameChecker
extends AbstractProjectChecker {
    private String[] projectPlugins = new String[]{"maven-ear-plugin", "maven-war-plugin", "maven-ejb-plugin", "maven-jar-plugin", "maven-rar-plugin"};

    @Override
    public String getCheckerDescription() {
        return "Checks if the pom.xml for (EAR, WAR, JAR, EJB) contains <finalName>${project.artifactId}</finalName>";
    }

    @Override
    public void processProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        NodeList plugins = (NodeList)this.getxPath().evaluate("//plugin/artifactId", doc, XPathConstants.NODESET);
        List pluginsList = Arrays.asList((Object[])this.projectPlugins);
        for (int x = 0; x < plugins.getLength(); ++x) {
            Node finalNameNode;
            Node pluginArtifact = plugins.item(x);
            if (!pluginsList.contains(pluginArtifact.getTextContent()) || (finalNameNode = (Node)this.getxPath().evaluate("//finalName", doc, XPathConstants.NODE)) != null && finalNameNode.getTextContent().equals("${project.artifactId}")) continue;
            int lineNumber = finalNameNode == null ? 0 : this.getLineNumberFromNode(finalNameNode);
            this.addViolation(project.getFile(), results, lineNumber, "File doesn't contain <finalName>${project.artifactId}</finalName>");
        }
    }
}

