/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ArrayQueue<T>
extends AbstractQueue<T>
implements Queue<T> {
    private final T[] elements;
    private int head;
    private int cnt;

    public ArrayQueue(int size) {
        this.elements = new Object[size];
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.cnt;
    }

    @Override
    public boolean offer(T o) {
        int cnt = this.cnt;
        T[] elements = this.elements;
        int length = elements.length;
        if (cnt == length) {
            return false;
        }
        elements[(this.head + cnt) % length] = o;
        this.cnt = cnt + 1;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T poll() {
        T[] elements = this.elements;
        int length = elements.length;
        int head = this.head;
        int cnt = this.cnt;
        if (cnt == 0) {
            return null;
        }
        try {
            T t = elements[head];
            return t;
        }
        finally {
            this.head = head + 1 % length;
            this.cnt = cnt - 1;
        }
    }

    @Override
    public T peek() {
        return this.cnt == 0 ? null : (T)this.elements[this.head];
    }
}

