/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jboss.logmanager.ExtLogRecord;

class WrappedExtLogRecord
extends ExtLogRecord {
    private static final long serialVersionUID = 980830752574061944L;
    private static final String LOGGER_CLASS_NAME = Logger.class.getName();
    private final transient LogRecord orig;
    private transient boolean resolved;

    WrappedExtLogRecord(LogRecord orig) {
        super(orig.getLevel(), orig.getMessage(), LOGGER_CLASS_NAME);
        this.orig = orig;
    }

    public String getLoggerName() {
        return this.orig.getLoggerName();
    }

    public void setLoggerName(String name) {
        super.setLoggerName(name);
        this.orig.setLoggerName(name);
    }

    public ResourceBundle getResourceBundle() {
        return this.orig.getResourceBundle();
    }

    public void setResourceBundle(ResourceBundle bundle) {
        super.setResourceBundle(bundle);
        this.orig.setResourceBundle(bundle);
    }

    public String getResourceBundleName() {
        return this.orig.getResourceBundleName();
    }

    public void setResourceBundleName(String name) {
        super.setResourceBundleName(name);
        this.orig.setResourceBundleName(name);
    }

    public Level getLevel() {
        return this.orig.getLevel();
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        this.orig.setLevel(level);
    }

    public long getSequenceNumber() {
        return this.orig.getSequenceNumber();
    }

    public void setSequenceNumber(long seq) {
        super.setSequenceNumber(seq);
        this.orig.setSequenceNumber(seq);
    }

    public String getSourceClassName() {
        if (!this.resolved) {
            this.resolve();
        }
        return super.getSourceClassName();
    }

    public void setSourceClassName(String sourceClassName) {
        this.resolved = true;
        super.setSourceClassName(sourceClassName);
        this.orig.setSourceClassName(sourceClassName);
    }

    public String getSourceMethodName() {
        if (!this.resolved) {
            this.resolve();
        }
        return super.getSourceMethodName();
    }

    public void setSourceMethodName(String sourceMethodName) {
        this.resolved = true;
        super.setSourceMethodName(sourceMethodName);
        this.orig.setSourceMethodName(sourceMethodName);
    }

    private void resolve() {
        StackTraceElement[] st;
        this.resolved = true;
        String sourceMethodName = this.orig.getSourceMethodName();
        String sourceClassName = this.orig.getSourceClassName();
        super.setSourceMethodName(sourceMethodName);
        super.setSourceClassName(sourceClassName);
        for (StackTraceElement element : st = new Throwable().getStackTrace()) {
            if (!element.getClassName().equals(sourceClassName) || !element.getMethodName().equals(sourceMethodName)) continue;
            super.setSourceLineNumber(element.getLineNumber());
            super.setSourceFileName(element.getFileName());
            return;
        }
    }

    public int getSourceLineNumber() {
        if (!this.resolved) {
            this.resolve();
        }
        return super.getSourceLineNumber();
    }

    public void setSourceLineNumber(int sourceLineNumber) {
        this.resolved = true;
        super.setSourceLineNumber(sourceLineNumber);
    }

    public String getSourceFileName() {
        if (!this.resolved) {
            this.resolve();
        }
        return super.getSourceFileName();
    }

    public void setSourceFileName(String sourceFileName) {
        this.resolved = true;
        super.setSourceFileName(sourceFileName);
    }

    public String getMessage() {
        return this.orig.getMessage();
    }

    public void setMessage(String message) {
        super.setMessage(message);
        this.orig.setMessage(message);
    }

    public Object[] getParameters() {
        return this.orig.getParameters();
    }

    public void setParameters(Object[] parameters) {
        this.orig.setParameters(parameters);
    }

    public int getThreadID() {
        return this.orig.getThreadID();
    }

    public void setThreadID(int threadID) {
        this.orig.setThreadID(threadID);
    }

    public long getMillis() {
        return this.orig.getMillis();
    }

    public void setMillis(long millis) {
        this.orig.setMillis(millis);
    }

    public Throwable getThrown() {
        return this.orig.getThrown();
    }

    public void setThrown(Throwable thrown) {
        this.orig.setThrown(thrown);
    }

    protected Object writeReplace() {
        return new ExtLogRecord(this);
    }
}

